%
function [spli ]=smooth_spline2DPt(x1,typeH,parH,SdStH,typeV,parV,SdStV,rho)

%x1 --samples of the input array at integer points {k,n=0:N-1}, N=2^j
%typeH type of horizontal subdivision (2--dyadic, 3--ternary
%parH spline order for horizontal subdivision
%SdStH number of iterations of horizontal subdivision
%typeV,parV,SdStV -- the same for vertical subdivision
%rho -- regularization parameter 
[lx,~]=size(x1);
fx=fft2(x1);
  [u1,~]=juviP(parH,lx);
 [u4,~]=juviP(2*parH,lx);
 u2=u1'*u1;
 u2=u2.^2;
n=0:lx-1;
   si=sin(pi*n/lx);
   W=(2*si).^parH.*u1;
   W=W'*u4;
  
   W2=W'+W;
    x=real(ifft2(u2./(rho*W2+u2).*fx));
 if SdStH>0   &SdStV>0   
     [spli]=intersplli2DPt(x,typeH,parH,SdStH,typeV,parV,SdStV);

 else
     spli=x;
    
 end




% % Copyright (c) 2012. Valery A. Zheludev
% 



