%S_filters
%magnitude responses of s-filters 1,2 and 3-d level

 N=256;
 n1=-N/2:N/2-1;
 n=0:N-1;
 P=[2:2:8];
 figure(1);
 for kk=1:4
     
 p=P(kk);
 [u,v]=juviP(2*p,N);
 [u1,v]=juviP(2*p,N/2);
 u1=[u1 u1];U=sqrt(u./(u1+eps));
 eval(['subplot(2,2,' int2str(kk) ')'])
 set(gca,'FontSize',16)
 
 
 co=cos(1*pi*n/N).^(p);
 Uc=U.*co;
 cU=circshift(Uc',N/2)';
 plot(n1,Uc,n1,cU,'k--','LineWidth',2)
 axis([-128,127,0,1.1])
 legend('\fontsize{14}s[n+N/2]','\fontsize{14}s[n]')
 title(['\fontsize{16}Spline order: '  int2str(P(kk))])
 end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(2);
 for kk=1:4
     
 p=P(kk);
 [u,v]=juviP(2*p,N);
 [u1,v]=juviP(2*p,N/2); 
 [u2,v]=juviP(2*p,N/4);
 u1=[u1 u1];U=sqrt(1*u./(u1+eps));
 u2=[u2 u2];
 u2=[u2 u2];
 U1=sqrt(1*u1./(u2+eps));
 eval(['subplot(2,2,' int2str(kk) ')'])
 set(gca,'FontSize',16)
 co1=cos(2*pi*n/N).^(p);
 
 co=cos(pi*n/N).^(p);
 Uc=U.*co;
 Uc1=U1.*co1;
 cU=circshift(Uc',N/2)';
 cU1=circshift(Uc1',N/4)';
 %plot(n,Uc,n,cU,'k--','LineWidth',2)
%plot(n1,Uc1.*Uc,n1,cU1.*cU,'k--','LineWidth',2)
plot(n1,cU1.*Uc,'b--',n1,Uc1.*cU,'k',n1,Uc1.*Uc,'b:',n1,cU1.*cU,'k-.','LineWidth',2)
 axis([-128,127,0,1.1])
 %legend('\fontsize{14}s[n+N/2]','\fontsize{14}s[n]')
 title(['\fontsize{16}Spline order: '  int2str(P(kk))])
 set(gca,'FontSize',16)
 end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 figure(3);
 for kk=1:4
     
 p=P(kk);
 [u,v]=juviP(2*p,N);
 [u1,v]=juviP(2*p,N/2); 
 [u2,v]=juviP(2*p,N/4);
 u1=[u1 u1];U=sqrt(1*u./(u1+eps));
 u2=[u2 u2];
 u2=[u2 u2];
 U1=sqrt(1*u1./(u2+eps));
 [u3,v]=juviP(2*p,N/8);
  u3=[u3 u3]; u3=[u3 u3]; u3=[u3 u3];
   U2=sqrt(1*u2./(u3+eps));
 eval(['subplot(2,2,' int2str(kk) ')'])
 
 co1=cos(2*pi*n/N).^(p);
 co2=cos(4*pi*n/N).^(p);
 
 co=cos(pi*n/N).^(p);
 Uc=U.*co;
 Uc1=U1.*co1;
 Uc2=U2.*co2;
 cU=circshift(Uc',N/2)';
 cU1=circshift(Uc1',N/4)';
 cU2=circshift(Uc2',N/8)';

plot(n1,cU1.*Uc.*Uc2,'b--',n1,Uc1.*cU.*Uc2,'k',n1,Uc1.*Uc.*Uc2,'b:',n1,cU1.*cU.*Uc2,'k-.',...
    n1,cU1.*Uc.*cU2,'b--',n1,Uc1.*cU.*cU2,'k',n1,Uc1.*Uc.*cU2,'b:',n1,cU1.*cU.*cU2,'k-.','LineWidth',2)
 axis([0,127,0,1.1])
 set(gca,'FontSize',16)
 %legend('\fontsize{14}s[n+N/2]','\fontsize{14}s[n]')
 title(['\fontsize{16}Spline order: '  int2str(P(kk))])
 end

 