function [q ,sigma, samp]=List_synthP_2D_samp(wctran,ListBB,Par)
%reconstruction of 2D spline  from the coefficients in the  wavelet packet basis, which is defined by 
% 'ListBB' list. 
%'wctran' cell array  of all the wavelet packet transform coefficients
%'q'--array of the coeff. in the o/n basis of the initial space
%'sigma'--SHA spectrum of the spline
%'samp' -- array of grid samples of the spline
 [~,M]=size(wctran{1});

[x, sigma]=List_synthP_2D(wctran,ListBB,Par);
q=real(ifft2(sigma));
[u,~]=juviP(Par,M);
[u2,~]=juviP(2*Par,M);
uu=u./sqrt(u2);
uu=uu'*uu;
samp=real(ifft2(sigma.*uu));
% Copyright (c) 2013. Valery A. Zheludev