function [ samp,q, sigma]=List_synthP_samp(wctran,ListBB,Par)
%reconstruction of 1D samples of splines from the coefficients in the  wavelet packet basis, which is defined by 
% 'ListBB' list. 
%'wctran' cell array  of all the wavelet packet transform coefficients
%'q'--array of the coeff. in the o/n basis of the initial space
%'sigma'--SHA spectrum of the spline
%'samp' -- array whose rows are   grid samples of the splines of order 'Par'
[~,M]=size(wctran{1});
[De,GS]=wavs_coefP(Par,M);
[ve t]=size(ListBB);

sigma=0;
for kk=1:ve
    [lev]=ListBB(kk,1);
    [blo]=ListBB(kk,2);
    ww=wctran{lev+1}{blo+1};
    s=fft(ww);
s=repmat(s,1,2^(lev));

g=GS{lev+1}{blo+1};
sigma=sigma+s.*g;
end
q=real(ifft(sigma));
[u,~]=juviP(Par,M);
[u2,~]=juviP(2*Par,M);
samp=real(ifft(sigma.*u./sqrt(u2)));
% Copyright (c) 2013. Valery A. Zheludev