function [wvtran, wctran, entro,ener]=samp_spl_WP_analP(samp,Par,DeTr)
%1D wavelet packet transform of an array 'samp', where each row  consists of grid samples of a spline of order 'Par' 
%transform in horizontal direction
%Par -spline order 
%DeTr--depth of transform
%samp--input array
%wvtran --cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the
%spline's coordinates in the wavelet packet basis from the level 'l-1', which are arranged according to their
%frequency content

%wctran -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the splines' coordinates
%in the wavelet packet basis  from the level 'l-1', where each block of coordinates
%occupies a separate subcell. Altogether cell #l comprizes 2^(l-1) subcells, which are labeled according to the  
%frequency content of the coefficients

% entro -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the entropies in  2^(l-1)blocks 
%of coordinates from the level 'l-1'
% ener -- cell array of size (DeTr+1,1),where  cell #l (l=1:DeTr+1)contains the l2 norms of  2^(l-1)blocks 
%of coordinates from the level 'l-1'

[vx M]=size(samp);

ny=sqrt(sum(samp(:).^2));
fx=fft(samp,[],2);
[u,~]=juviP(Par,M);
[u2,~]=juviP(2*Par,M);
uu=sqrt(u2)./u;
uu=repmat(uu,vx,1);
fx=uu.*fx;
x=real(ifft(fx,[],2));
[wvtran, wctran, entro,ener]=spl_WP_analP(x,Par,DeTr);


%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2013. Valery A. Zheludev
