function [wvt, wct, fwvt,ent,ene]=wP_downP(Lev,M,fx,A,ny) 
%one step of wavelet packet transform of a signal from the level 'Lev' to the level 'Lev+1' 
%M-- length of input array
%fx -- DFT of input array 
%ny -- l2 norm of the signal at the initial level (Lev=0)

%wvt -- array of coordinates in the wavelet packet basis from the level 'Lev', which are arranged according to their
%frequency content

%wct -- the coordinates are arranged into cell array, where each out of 2^(Lev+1) blocks of coordinates
%occupies a separate subcell. 
% ent  -- array of  the entropies in 2^(Lev+1) blocks of coordinates from the level 'Lev+1'
% ene -- array of  the l2 norms of 2^(Lev+1) blocks of coordinates from the level 'Lev+1'

 m=1:M;
wvt=[];
  wct=cell(1,2^Lev);
  fwvt=[];
  ent=zeros(1,2^Lev);
  ene=zeros(1,2^Lev);
  for mm=1:2^(Lev-1)
      flo=fx(:,M*(mm-1)+m);
 [ flo, fhi]=flohiP(flo,A); 
r=rem(mm,2);
  Wef=r*flo+(1-r)*fhi;
  Wof=r*fhi+(1-r)*flo;
  We=real(ifft(Wef,[],2));
  Wo=real(ifft(Wof,[],2));
  
  wvt=[wvt We Wo];
  ent(2*mm-1)=caenP(We,1,ny);
  ent(2*mm)=caenP(Wo,1,ny);
 ene(2*mm-1)=norm(We);
  ene(2*mm)=norm(Wo);
 wct{2*mm-1}=We;
  wct{2*mm}=Wo;
  fwvt=[fwvt, Wef Wof];
  end 
  
  

