function [wvt, wct, fwvt,ent,ene]=wP_down_2DP(Lev,M,fx,A,ny)

%one step of 2D wavelet packet transform of a signal from the level 'Lev' to the level 'Lev+1' 
%[M,M]-- size of input array
%fx -- 2D DFT of input array 
%ny -- ny=sqrt(sum(X(:).^2)), where 'X' is  the signal at the initial level (Lev=0)

%wvt -- array of coordinates in the wavelet packet basis from the level 'Lev', which are arranged according to their
%frequency content

%wct -- the coordinates are arranged into cell array, where each out of 4^(Lev+1) blocks of coordinates
%occupies a separate subcell. 
% ent  -- array of  the entropies in 4^(Lev+1) blocks of coordinates from the level 'Lev+1'
% ene -- array of  the l2 norms of 4^(Lev+1) blocks of coordinates from the level 'Lev+1'

 m=1:M;
wvt=[];
  wct=cell(2^Lev);
  %fwvt=[];
  ent=zeros(2^Lev);
  ene=zeros(2^Lev);
  fx=transpose(wewof(fx,Lev,A,M));
fwvt=transpose(wewof(fx,Lev,A,M));  
M2=M/2;
vh=1:M2;
for vv=1:2^Lev
 for hh=1:2^Lev  
 F=fwvt(M2*(vv-1)+vh, M2*(hh-1)+vh);
 
 W=real(ifft2(F));
 wvt(M2*(vv-1)+vh, M2*(hh-1)+vh)=W;
 wct{vv,hh}=W;
 ent(vv,hh)=caenP(W(:),1,ny);
  ene(vv,hh)=norm(W(:));
 end
end
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    function fwvt=wewof(fx,Lev,A,M)
   fwvt=[];   
    m=1:M;
 for mm=1:2^(Lev-1)
      flo=fx(:,M*(mm-1)+m);

 [ flo fhi]=flohiP(flo,A); 
r=rem(mm,2);
  Wef=r*flo+(1-r)*fhi;
  Wof=r*fhi+(1-r)*flo;

  fwvt=[fwvt, Wef Wof];
  end  
% Copyright (c) 2013. Valery A. Zheludev  
