
function [u_ref] = exact_solution_2x2(mean_left,mean_right,sig_h,T,m,left,right,x0,x)

% Compute the analytical solution of the 2x2 stochastic Galerkin Burgers'
% equation

% Indata:
% mean_left,mean_right - Mean (u_0) of the left and right states
% sig_h - Standard deviation (u_1), assumed uniform over the spatial domain
% T - Time
% m - Number of spatial grid points
% left - Lower limit of spatial interval
% right - Upper limit of spatial interval
% x0 - Initial shock location
% x - Vector of spatial grid points

% Outdata:
% u_ref - Analysical solution


s1 = (mean_left+mean_right)/2-sig_h; % Shock speed 1
s2 = (mean_left+mean_right)/2+sig_h; % Shock speed 2

u_ref = zeros(m,2);

for j=1:m
    if x(j)< x0+s1*T
        u_ref(j,1)=mean_left;
        u_ref(j,2)=sig_h;
    end
    if x(j)>= x0+s1*T && x(j) < x0+s2*T
        u_ref(j,1)= (mean_left+mean_right)/2;
        u_ref(j,2) = (mean_left-mean_right)/2+sig_h;
    end
    if x(j)> x0+s2*T
        u_ref(j,1)= mean_right;
        u_ref(j,2) = sig_h;
    end
end