
function [u_ref] = exact_solution_determ(mean_left,mean_right,T,m,left,right,x0,x)

% Compute the exact solution of the deterministic Burgers' equation

% Indata:
% mean_left,mean_right - Left and right states
% T - Time
% m - Number of spatial grid points
% left - Lower limit of spatial interval
% right - Upper limit of spatial interval
% x0 - Initial shock location
% x - Vector of spatial grid points

% Outdata:
% u_ref - Analytical solution


s = (mean_left + mean_right)/2; % Shock speed
u_ref = zeros(m,1);

for j=1:m
    if x(j)< x0+s*T
        u_ref(j,1)=mean_left;
    end
    
    if x(j)>= x0+s*T
        u_ref(j,1)= mean_right;
    end
end