
function [flux] = flux_func(u,p,C)

% Flux function, yields the stochastic Galerkin flux f = 0.5*A(u)u 

% Indata: 
% u - Vector of solution variables (gPC coefficients)
% p - Number of gPC basis functions
% C - Triple product matrix

% Outdata:
% flux - Stochastic Galerkin flux function


flux = zeros(length(u),1);

for i=0:length(u)/p-1 % Loop over the spatial grid points
    u_part=u(p*i+1:p*(i+1),1);    
    flux(i*p+1:(i+1)*p,1) = 0.5*A_matrix(u_part,p,C)*u_part;
end
