
function [u_init] = initial_conditions(m,p,C,x0,mean_left,std_left,mean_right,std_right,left,right)

% Compute initial conditions (gPC coefficients) for the Riemann problem

% Indata:
% m - Number of spatial grid points
% p - Number of gPC coefficients to be computed
% C - Inner triple product matrices
% x0 - Initial shock location
% mean_left - Left mean state
% std_left - Standard deviation left state
% mean_right - Right mean state
% std_right - Standard deviation right state
% left - Lower limit of spatial interval
% right - Upper limit of spatial interval

% Output:
% u_init - Vector of initial gPC coefficients

u_init = zeros(m*p,1);

for i=1:p:p*(ceil(m*(x0-left)/(right-left))-1)+1
    u_init(i) = mean_left;
    if p>1
        u_init(i+1) = std_left;
    end
end
for (i=ceil(m*(x0-left)/(right-left))*p+1:p:p*(m-1)+1)
    u_init(i) = mean_right;
    if p>1
        u_init(i+1) = std_right;
    end
end







