
function [A] = A_matrix(u_loc,p,C)

% Compute the matrix A(u) of triple inner products, 
% where A_{i,j} =  sum_{k=0}^{p}  int u_k psi_i psi_j psi_k dP

% Indata:
% u_loc - Vector of gPC coefficients of the argument u
% p - Number of gPC basis functions
% C - Precomputed inner triple products of the basis functions psi

% Outdata:
% A - matrix of sums of inner products


A = zeros(p);

for j=1:p
    A = A + C(:,:,j)*u_loc(j);
end