
function [u_init] = init_Hermite(rho_0,c1,c2,v,t,t0,x,x0,m,P)

% Generate initial function for Hermite polynomials and lognormal viscosity

% Indata:
% rho_0 - Solution scaling parameter (assumed deterministic)
% c1,c2 - Scaling parameters of lognormal viscosity
% v - Advective velocity
% t - Time
% t0 - Initial time
% x - Vector of spatial grid points
% x0 - Initial shock location
% m - Number of spatial grid points
% P - Number of gPC coefficients to be computed

% Outdata:
% u_init - gPC coefficients of the initial function evaluated at the spatial grid points


u_init = zeros(m*P,1);
tol = 20; % Replace integration limits of infinity by some sufficiently large number

% Generate normalized Hermite polynomials recursively

basis_fun = cell(1,P);
basis_fun{1} = @(xi) xi.^0;
basis_fun{2} = @(xi) xi;
for k=3:P
    basis_fun{k} = @(xi) 1/sqrt(k-1)*xi.*basis_fun{k-1}(xi)-sqrt((k-2)/(k-1))*basis_fun{k-2}(xi);
end

% Viscocity with shifted lognormal distribution
mu_fun = @(xi) c1+c2*exp(xi);

for k=1:P
    for j=1:m
        integ = @(xi) 1/sqrt(2*pi).*exp(-xi.^2/2).*basis_fun{k}(xi).*rho_0./sqrt(4*pi*mu_fun(xi)*(t+t0)).*exp(-(x(j)-(x0+v*(t+t0))).^2./(4*mu_fun(xi).*(t+t0)));
        u_init((j-1)*P+k,1) = quadgk(integ,-tol,tol); % Integration over the real line replaced with finite interval
    end
end
