
function [B] = mu_SG_lognormal(c1,c2,P)

% Compute the stochastic Galerkin viscosity matrix B with normalized Hermite
% polynomials

% Indata:
% c1, c2 - Scaling parameters of shifted lognormal distribution
% P - Number of gPC terms to be retained 

% Outdata:
% B - Viscosity matrix, [B]_{ij} = sum_{k}^{2P}<psi_i psi_j psi_k> mu_k

% For the 1D case, use twice as many basis functions as for the variables
% (see Proposition 1 in Chapter 5)

P2 = 2*P;
C = hermite_chaos(P2-1); 

tol = 30;

% Recursively generate Hermite polynomials
basis_fun = cell(1,P2);
basis_fun{1} = @(xi) xi.^0;
basis_fun{2} = @(xi) xi;
for k=3:P2
    basis_fun{k} = @(xi) 1/sqrt(k-1)*xi.*basis_fun{k-1}(xi)-sqrt((k-2)/(k-1))*basis_fun{k-2}(xi);
end

visc_fun = @(x) c1+c2*exp(x);

B = zeros(P2);

for k=1:P2
    integ = @(x) 1/sqrt(2*pi).*exp(-x.^2/2).*basis_fun{k}(x).*visc_fun(x);
    visc_hc(k,1) = quadgk(integ,-tol,tol);
    B = B+C(:,:,k)*visc_hc(k,1);
end

B = B(1:P,1:P);
