
function [u_mean u_var] = statistics_adv_diff_uniform_mu(m,t,x,x0,c1,c2,rho_0,t0,v)

% Compute mean and variance for the solution assuming uniformly distributed viscosity

% Indata:
% m - Number of spatial grid points
% t - Time
% x - Vector of spatial grid points
% x0 - Initial pulse location
% c1,c2 - Scaling parameters of uniformly distributed viscosity
% rho_0 - Solution scaling parameter (assumed deterministic)
% t0 - Initial time
% v - Advective velocity

% Outdata:
% u_mean - Mean solution evaluated on the spatial grid
% u_var - Variance of the solution evaluated on the spatial grid


mu0 = @(xi) c1+c2*xi;

% For each spatial grid point, compute mean and variance
for j=1:m
    u = @(xi) rho_0./(4*pi*mu0(xi)*(t+t0)).^0.5.*exp(-(x(j)-(x0+v*(t+t0))).^2./(4*mu0(xi)*(t+t0)));
    u_mean(j,1) = quad(@(xi) 0.5*u(xi),-1,1);
    u_var(j,1) = quad(@(xi) 0.5*(u(xi).^2-u_mean(j,1).^2),-1,1);
end