
function [D1 D2,BS,S,H] = SBP_operators(n,dx,order)

% SBP operators of orders 2, 4, 6 and 8 for the first and second derivative.

% Indata:
% n - Number of spatial grid pts
% dx - Step size
% order - Order of accuracy (only for 2,4,6,8)

% Outdata:
% D1 - First derivative operator
% D2 - Second derivative operator (D = P^{-1}M)
% S - First derivative operator on boundaries
% BS - The boundary elements in the energy estimate
% H - The norm operator (denoted P in some papers)


e = ones(n,1);

if order==2
    
    D1 = 1/dx*spdiags([-1/2*e 0*e 1/2*e],-1:1,n,n);
    D1(1,1) = -1/dx;
    D1(1,2) = 1/dx;
    D1(1,3) = 0;
    D1(n,n) = 1/dx;
    D1(n,n-1) = -1/dx;
    D1(n,n-2) = 0;
    
    %%%%%%
    D2 = 1/(dx^2)*spdiags([1*e -2*e 1*e],-1:1,n,n);
    D2(1,1) = 1/(dx^2);
    D2(1,2) = -2/(dx^2);
    D2(1,3) = 1/(dx^2);
    D2(n,n) = 1/(dx^2);
    D2(n,n-1) = -2/(dx^2);
    D2(n,n-2) = 1/(dx^2);
    
    
    H = dx*spdiags([e],0,n,n);
    H(1,1) = dx*1/2;
    H(n,n) = dx*1/2;
    
    BS = (1/dx)*spdiags(zeros(size(e)),0,n,n);
    BS(1,1) = 3/2/dx;
    BS(1,2) = -2/dx;
    BS(1,3) = 1/2/dx;
    BS(n,n) = 3/2/dx;
    BS(n,n-1) = -2/dx;
    BS(n,n-2) = 1/2/dx;
    
    S = (1/dx)*spdiags([e],0,n,n);
    S(1,1) = -3/2/dx;
    S(1,2) = 2/dx;
    S(1,3) = -1/2/dx;
    
    S(n,n) = 3/2/dx;
    S(n,n-1) = -2/dx;
    S(n,n-2) = 1/2/dx;
    
elseif order==4
    
    D1 = 1/dx*spdiags([1/12*e -2/3*e 0*e 2/3*e -1/12*e],-2:2,n,n);
    D1(1,1) = -24/17/dx;
    D1(1,2) = 59/34/dx;
    D1(1,3) = -4/17/dx;
    D1(1,4) = -3/34/dx;
    D1(1,5) = 0;
    D1(1,6) = 0;
    D1(2,1) = -1/2/dx;
    D1(2,2) = 0;
    D1(2,3) = 1/2/dx;
    D1(2,4:6) = 0;
    D1(3,1) = 4/43/dx;
    D1(3,2) = -59/86/dx;
    D1(3,3) = 0;
    D1(3,4) = 59/86/dx;
    D1(3,5) = -4/43/dx;
    D1(3,6) = 0;
    D1(4,1) = 3/98/dx;
    D1(4,2) = 0;
    D1(4,3) = -59/98/dx;
    D1(4,4) = 0;
    D1(4,5) = 32/49/dx;
    D1(4,6) = -4/49/dx;
    D1(4,7) = 0;
    D1(n,n) = -D1(1,1);
    D1(n,n-1) = -D1(1,2);
    D1(n,n-2) = -D1(1,3);
    D1(n,n-3) = -D1(1,4);
    D1(n,n-4) = -D1(1,5);
    D1(n,n-5) = -D1(1,6);
    D1(n-1,n) = -D1(2,1);
    D1(n-1,n-1) = -D1(2,2);
    D1(n-1,n-2) = -D1(2,3);
    D1(n-1,n-3) = -D1(2,4);
    D1(n-1,n-4) = -D1(2,5);
    D1(n-1,n-5) = -D1(2,6);
    D1(n-2,n) = -D1(3,1);
    D1(n-2,n-1) = -D1(3,2);
    D1(n-2,n-2) = -D1(3,3);
    D1(n-2,n-3) = -D1(3,4);
    D1(n-2,n-4) = -D1(3,5);
    D1(n-2,n-5) = -D1(3,6);
    D1(n-3,n) = -D1(4,1);
    D1(n-3,n-1) = -D1(4,2);
    D1(n-3,n-2) = -D1(4,3);
    D1(n-3,n-3) = -D1(4,4);
    D1(n-3,n-4) = -D1(4,5);
    D1(n-3,n-5) = -D1(4,6);
    
    
    %%%%%%
    D2 = 1/(dx^2)*spdiags([-1/12*e 4/3*e -5/2*e 4/3*e -1/12*e],-2:2,n,n);
    D2(1,1) = 2/(dx^2);
    D2(1,2) = -5/(dx^2);
    D2(1,3) = 4/(dx^2);
    D2(1,4) = -1/(dx^2);
    D2(2,1) = 1/(dx^2);
    D2(2,2) = -2/(dx^2);
    D2(2,3) = 1/(dx^2);
    D2(2,4) = 0;
    D2(3,1) = -4/43/(dx^2);
    D2(3,2) = 59/43/(dx^2);
    D2(3,3) = -110/43/(dx^2);
    D2(3,4) = 59/43/(dx^2);
    D2(3,5) = -4/43/(dx^2);
    D2(4,1) = -1/49/(dx^2);
    D2(4,2) = 0;
    D2(4,3) = 59/49/(dx^2);
    D2(4,4) = -118/49/(dx^2);
    D2(4,5) = 64/49/(dx^2);
    D2(4,6) = -4/49/(dx^2);
    D2(n,n) = D2(1,1);
    D2(n,n-1) = D2(1,2);
    D2(n,n-2) = D2(1,3);
    D2(n,n-3) = D2(1,4);
    D2(n-1,n) = D2(2,1);
    D2(n-1,n-1) = D2(2,2);
    D2(n-1,n-2) = D2(2,3);
    D2(n-1,n-3) = D2(2,4);
    D2(n-2,n) = D2(3,1);
    D2(n-2,n-1) = D2(3,2);
    D2(n-2,n-2) = D2(3,3);
    D2(n-2,n-3) = D2(3,4);
    D2(n-2,n-4) = D2(3,5);
    D2(n-3,n) = D2(4,1);
    D2(n-3,n-1) = D2(4,2);
    D2(n-3,n-2) = D2(4,3);
    D2(n-3,n-3) = D2(4,4);
    D2(n-3,n-4) = D2(4,5);
    D2(n-3,n-5) = D2(4,6);
    
    H = dx*spdiags(e,0,n,n);
    H(1,1) = dx*17/48;
    H(2,2) = dx*59/48;
    H(3,3) = dx*43/48;
    H(4,4) = dx*49/48;
    H(n,n) = H(1,1);
    H(n-1,n-1) = H(2,2);
    H(n-2,n-2) = H(3,3);
    H(n-3,n-3) = H(4,4);
    
    S = (1/dx)*spdiags(e,0,n,n);
    S(1,1) = -11/6/dx;
    S(1,2) = 3/dx;
    S(1,3) = -3/2/dx;
    S(1,4) = 1/3/dx;
    S(n,n) = 11/6/dx;
    S(n,n-1) = -3/dx;
    S(n,n-2) = 3/2/dx;
    S(n,n-3) = -1/3/dx;
    
    BS = (1/dx)*spdiags(zeros(size(e)),0,n,n);
    BS(1,1) = 11/6/dx;
    BS(1,2) = -3/dx;
    BS(1,3) = 3/2/dx;
    BS(1,4) = -1/3/dx;
    BS(n,n) = 11/6/dx;
    BS(n,n-1) = -3/dx;
    BS(n,n-2) = 3/2/dx;
    BS(n,n-3) = -1/3/dx;
    
elseif order==6
    e = ones(n,1);
    %%%%
    D1 = (1/(dx))*spdiags([-1/60*e 3/20*e -3/4*e 0*e 3/4*e -3/20*e 1/60*e],-3:3,n,n);
    
    D1(1,1) = -21600/13649/dx;
    D1(1,2) = 104009/54596/dx;
    D1(1,3) = 30443/81894/dx;
    D1(1,4) = -33311/27298/dx;
    D1(1,5) = 16863/27298/dx;
    D1(1,6) = -15025/163788/dx;
    D1(1,7) = 0;
    D1(1,8) = 0;
    D1(2,1) = -104009/240260/dx;
    D1(2,2) = 0;
    D1(2,3) = -311/72078/dx;
    D1(2,4) = 20229/24026/dx;
    D1(2,5) = -24337/48052/dx;
    D1(2,6) = 36661/360390/dx;
    D1(2,7) = 0;
    D1(2,8) = 0;
    D1(3,1) = -30443/162660/dx;
    D1(3,2) = 311/32532/dx;
    D1(3,3) = 0;
    D1(3,4) = -11155/16266/dx;
    D1(3,5) = 41287/32532/dx;
    D1(3,6) = -21999/54220/dx;
    D1(3,7) = 0;
    D1(3,8) = 0;
    D1(4,1) = 33311/107180/dx;
    D1(4,2) = -20229/21436/dx;
    D1(4,3) = 485/1398/dx;
    D1(4,4) = 0;
    D1(4,5) = 4147/21436/dx;
    D1(4,6) = 25427/321540/dx;
    D1(4,7) = 72/5359/dx;
    D1(4,8) = 0;
    D1(5,1) = -16863/78770/dx;
    D1(5,2) = 24337/31508/dx;
    D1(5,3) = -41287/47262/dx;
    D1(5,4) = -4147/15754/dx;
    D1(5,5) = 0;
    D1(5,6) = 342523/472620/dx;
    D1(5,7) = -1296/7877/dx;
    D1(5,8) = 144/7877/dx;
    D1(5,9) = 0;
    D1(6,1) = 15025/525612/dx;
    D1(6,2) = -36661/262806/dx;
    D1(6,3) = 21999/87602/dx;
    D1(6,4) = -25427/262806/dx;
    D1(6,5) = -342523/525612/dx;
    D1(6,6) = 0;
    D1(6,7) = 32400/43801/dx;
    D1(6,8) = -6480/43801/dx;
    D1(6,9) = 720/43801/dx;
    D1(6,10) = 0;
    D1(n,n) = -D1(1,1);
    D1(n,n-1) = -D1(1,2);
    D1(n,n-2) = -D1(1,3);
    D1(n,n-3) = -D1(1,4);
    D1(n,n-4) = -D1(1,5);
    D1(n,n-5) = -D1(1,6);
    D1(n,n-6) = -D1(1,7);
    D1(n,n-7) = -D1(1,8);
    D1(n-1,n) = -D1(2,1);
    D1(n-1,n-1) = -D1(2,2);
    D1(n-1,n-2) = -D1(2,3);
    D1(n-1,n-3) = -D1(2,4);
    D1(n-1,n-4) = -D1(2,5);
    D1(n-1,n-5) = -D1(2,6);
    D1(n-1,n-6) = -D1(2,7);
    D1(n-1,n-7) = -D1(2,8);
    D1(n-2,n) = -D1(3,1);
    D1(n-2,n-1) = -D1(3,2);
    D1(n-2,n-2) = -D1(3,3);
    D1(n-2,n-3) = -D1(3,4);
    D1(n-2,n-4) = -D1(3,5);
    D1(n-2,n-5) = -D1(3,6);
    D1(n-2,n-6) = -D1(3,7);
    D1(n-2,n-7) = -D1(3,8);
    D1(n-3,n) = -D1(4,1);
    D1(n-3,n-1) = -D1(4,2);
    D1(n-3,n-2) = -D1(4,3);
    D1(n-3,n-3) = -D1(4,4);
    D1(n-3,n-4) = -D1(4,5);
    D1(n-3,n-5) = -D1(4,6);
    D1(n-3,n-6) = -D1(4,7);
    D1(n-3,n-7) = -D1(4,8);
    D1(n-4,n) = -D1(5,1);
    D1(n-4,n-1) = -D1(5,2);
    D1(n-4,n-2) = -D1(5,3);
    D1(n-4,n-3) = -D1(5,4);
    D1(n-4,n-4) = -D1(5,5);
    D1(n-4,n-5) = -D1(5,6);
    D1(n-4,n-6) = -D1(5,7);
    D1(n-4,n-7) = -D1(5,8);
    D1(n-4,n-8) = -D1(5,9);
    D1(n-5,n) = -D1(6,1);
    D1(n-5,n-1) = -D1(6,2);
    D1(n-5,n-2) = -D1(6,3);
    D1(n-5,n-3) = -D1(6,4);
    D1(n-5,n-4) = -D1(6,5);
    D1(n-5,n-5) = -D1(6,6);
    D1(n-5,n-6) = -D1(6,7);
    D1(n-5,n-7) = -D1(6,8);
    D1(n-5,n-8) = -D1(6,9);
    D1(n-5,n-9) = -D1(6,10);
    
    %%%%
    D2 = (1/(dx^2))*spdiags([1/90*e -3/20*e 3/2*e -49/18*e 3/2*e -3/20*e 1/90*e],-3:3,n,n);
    
    D2(1,1) = 114170/40947/(dx^2);
    D2(1,2) = -438107/54596/(dx^2);
    D2(1,3) = 336409/40947/(dx^2);
    D2(1,4) = -276997/81894/(dx^2);
    D2(1,5) = 3747/13649/(dx^2);
    D2(1,6) = 21035/163788/(dx^2);
    D2(1,7) = 0;
    D2(1,8) = 0;
    D2(2,1) = 6173/5860/(dx^2);
    D2(2,2) = -2066/879/(dx^2);
    D2(2,3) = 3283/1758/(dx^2);
    D2(2,4) =-303/293/(dx^2);
    D2(2,5) = 2111/3516/(dx^2);
    D2(2,6) = -601/4395/(dx^2);
    D2(2,7) = 0;
    D2(2,8) = 0;
    D2(3,1) = -52391/81330/(dx^2);
    D2(3,2) = 134603/32532/(dx^2);
    D2(3,3) = -21982/2711/(dx^2);
    D2(3,4) = 112915/16266/(dx^2);
    D2(3,5) = -46969/16266/(dx^2);
    D2(3,6) = 30409/54220/(dx^2);
    D2(3,7) = 0;
    D2(3,8) = 0;
    D2(4,1) = 68603/321540/(dx^2);
    D2(4,2) = -12423/10718/(dx^2);
    D2(4,3) = 112915/32154/(dx^2);
    D2(4,4) = -75934/16077/(dx^2);
    D2(4,5) = 53369/21436/(dx^2);
    D2(4,6) = -54899/160770/(dx^2);
    D2(4,7) = 48/5359/(dx^2);
    D2(4,8) = 0;
    D2(5,1) = -7053/39385/(dx^2);
    D2(5,2) = 86551/94524/(dx^2);
    D2(5,3) = -46969/23631/(dx^2);
    D2(5,4) = 53369/15754/(dx^2);
    D2(5,5) = -87904/23631/(dx^2);
    D2(5,6) = 820271/472620/(dx^2);
    D2(5,7) = -1296/7877/(dx^2);
    D2(5,8) = 96/7877/(dx^2);
    D2(5,9) = 0;
    D2(6,1) = 21035/525612/(dx^2);
    D2(6,2) = -24641/131403/(dx^2);
    D2(6,3) = 30409/87602/(dx^2);
    D2(6,4) = -54899/131403/(dx^2);
    D2(6,5) = 820271/525612/(dx^2);
    D2(6,6) = -117600/43801/(dx^2);
    D2(6,7) = 64800/43801/(dx^2);
    D2(6,8) = -6480/43801/(dx^2);
    D2(6,9) = 480/43801/(dx^2);
    D2(6,10) = 0;
    D2(n,n) = D2(1,1);
    D2(n,n-1) = D2(1,2);
    D2(n,n-2) = D2(1,3);
    D2(n,n-3) = D2(1,4);
    D2(n,n-4) = D2(1,5);
    D2(n,n-5) = D2(1,6);
    D2(n,n-6) = D2(1,7);
    D2(n,n-7) = D2(1,8);
    D2(n-1,n) = D2(2,1);
    D2(n-1,n-1) = D2(2,2);
    D2(n-1,n-2) = D2(2,3);
    D2(n-1,n-3) = D2(2,4);
    D2(n-1,n-4) = D2(2,5);
    D2(n-1,n-5) = D2(2,6);
    D2(n-1,n-6) = D2(2,7);
    D2(n-1,n-7) = D2(2,8);
    D2(n-2,n) = D2(3,1);
    D2(n-2,n-1) = D2(3,2);
    D2(n-2,n-2) = D2(3,3);
    D2(n-2,n-3) = D2(3,4);
    D2(n-2,n-4) = D2(3,5);
    D2(n-2,n-5) = D2(3,6);
    D2(n-2,n-6) = D2(3,7);
    D2(n-2,n-7) = D2(3,8);
    D2(n-3,n) = D2(4,1);
    D2(n-3,n-1) = D2(4,2);
    D2(n-3,n-2) = D2(4,3);
    D2(n-3,n-3) = D2(4,4);
    D2(n-3,n-4) = D2(4,5);
    D2(n-3,n-5) = D2(4,6);
    D2(n-3,n-6) = D2(4,7);
    D2(n-3,n-7) = D2(4,8);
    D2(n-4,n) = D2(5,1);
    D2(n-4,n-1) = D2(5,2);
    D2(n-4,n-2) = D2(5,3);
    D2(n-4,n-3) = D2(5,4);
    D2(n-4,n-4) = D2(5,5);
    D2(n-4,n-5) = D2(5,6);
    D2(n-4,n-6) = D2(5,7);
    D2(n-4,n-7) = D2(5,8);
    D2(n-4,n-8) = D2(5,9);
    D2(n-5,n) = D2(6,1);
    D2(n-5,n-1) = D2(6,2);
    D2(n-5,n-2) = D2(6,3);
    D2(n-5,n-3) = D2(6,4);
    D2(n-5,n-4) = D2(6,5);
    D2(n-5,n-5) = D2(6,6);
    D2(n-5,n-6) = D2(6,7);
    D2(n-5,n-7) = D2(6,8);
    D2(n-5,n-8) = D2(6,9);
    D2(n-5,n-9) = D2(6,10);
    
    H = dx*spdiags([e],0,n,n);
    
    H(1,1) = dx*13649/43200;
    H(2,2) = dx*12013/8640;
    H(3,3) = dx*2711/4320;
    H(4,4) = dx*5359/4320;
    H(5,5) = dx*7877/8640;
    H(6,6) = dx*43801/43200;
    H(n,n) = H(1,1);
    H(n-1,n-1) = H(2,2);
    H(n-2,n-2) = H(3,3);
    H(n-3,n-3) = H(4,4);
    H(n-4,n-4) = H(5,5);
    H(n-5,n-5) = H(6,6);
    
    BS = (1/dx)*spdiags([zeros(size(e))],0,n,n);
    
    BS(1,1) = 25/12/dx;
    BS(1,2) = -4/dx;
    BS(1,3) = 3/dx;
    BS(1,4) = -4/3/dx;
    BS(1,5) = 1/4/dx;
    BS(n,n) = BS(1,1);
    BS(n,n-1) = BS(1,2);
    BS(n,n-2) = BS(1,3);
    BS(n,n-3) = BS(1,4);
    BS(n,n-4) = BS(1,5);
    
    
    S = (1/dx)*spdiags([e],0,n,n);
    
    S(1,1) = -25/12/dx;
    S(1,2) = 4/dx;
    S(1,3) = -3/dx;
    S(1,4) = 4/3/dx;
    S(1,5) = -1/4/dx;
    S(n,n) = BS(1,1);
    S(n,n-1) = BS(1,2);
    S(n,n-2) = BS(1,3);
    S(n,n-3) = BS(1,4);
    S(n,n-4) = BS(1,5);
    
    
    
    
elseif order==8
    e = ones(n,1);
    
    D = (1/(dx^2))*spdiags([-1/560*e 8/315*e -1/5*e 8/5*e -205/72*e 8/5*e -1/5*e 8/315*e -1/560*e],-4:4,n,n);
    % eighth order standard central stencil
    
    D(1,1) = 4870382994799/1358976868290/(dx^2);
    D(1,2) = -893640087518/75498714905/(dx^2);
    D(1,3) = 926594825119/60398971924/(dx^2);
    D(1,4) = -1315109406200/135897686829/(dx^2);
    D(1,5) = 39126983272/15099742981/(dx^2);
    D(1,6) = 12344491342/75498714905/(dx^2);
    D(1,7) = -451560522577/2717953736580/(dx^2);
    D(1,8) = 0;
    D(1,9) = 0;
    D(1,10) = 0;
    D(1,11) = 0;
    D(1,12) = 0;
    D(2,1) = 333806012194/390619153855/(dx^2);
    D(2,2) = -154646272029/111605472530/(dx^2);
    D(2,3) = 1168338040/33481641759/(dx^2);
    D(2,4) = 82699112501/133926567036/(dx^2);
    D(2,5) = -171562838/11160547253/(dx^2);
    D(2,6) = -28244698346/167408208795/(dx^2);
    D(2,7) = 11904122576/167408208795/(dx^2);
    D(2,8) = -2598164715/312495323084/(dx^2);
    D(2,9) = 0;
    D(2,10) = 0;
    D(2,11) = 0;
    D(2,12) = 0;
    D(3,1) = 7838984095/52731029988/(dx^2);
    D(3,2) = 1168338040/5649753213/(dx^2);
    D(3,3) = -88747895/144865467/(dx^2);
    D(3,4) = 423587231/627750357/(dx^2);
    D(3,5) = -43205598281/22599012852/(dx^2);
    D(3,6) = 4876378562/1883251071/(dx^2);
    D(3,7) = -5124426509/3766502142/(dx^2);
    D(3,8) = 10496900965/39548272491/(dx^2);
    D(3,9) = 0;
    D(3,10) = 0;
    D(3,11) = 0;
    D(3,12) = 0;
    D(4,1) = -94978241528/828644350023/(dx^2);
    D(4,2) = 82699112501/157837019052/(dx^2);
    D(4,3) = 1270761693/13153084921/(dx^2);
    D(4,4) = -167389605005/118377764289/(dx^2);
    D(4,5) = 48242560214/39459254763/(dx^2);
    D(4,6) = -31673996013/52612339684/(dx^2);
    D(4,7) = 43556319241/118377764289/(dx^2);
    D(4,8) = -44430275135/552429566682/(dx^2);
    D(4,9) = 0;
    D(4,10) = 0;
    D(4,11) = 0;
    D(4,12) = 0;
    D(5,1) = 1455067816/21132528431/(dx^2);
    D(5,2) = -171562838/3018932633/(dx^2);
    D(5,3) = -43205598281/36227191596/(dx^2);
    D(5,4) = 48242560214/9056797899/(dx^2);
    D(5,5) = -52276055645/6037865266/(dx^2);
    D(5,6) = 57521587238/9056797899/(dx^2);
    D(5,7) = -80321706377/36227191596/(dx^2);
    D(5,8) = 8078087158/21132528431/(dx^2);
    D(5,9) = -1296/299527/(dx^2);
    D(5,10) = 0;
    D(5,11) = 0;
    D(5,12) = 0;
    D(6,1) = 10881504334/327321118845/(dx^2);
    D(6,2) = -28244698346/140280479505/(dx^2);
    D(6,3) = 4876378562/9352031967/(dx^2);
    D(6,4) = -10557998671/12469375956/(dx^2);
    D(6,5) = 57521587238/28056095901/(dx^2);
    D(6,6) = -278531401019/93520319670/(dx^2);
    D(6,7) = 73790130002/46760159835/(dx^2);
    D(6,8) = -137529995233/785570685228/(dx^2);
    D(6,9) = 2048/103097/(dx^2);
    D(6,10) = -144/103097/(dx^2);
    D(6,11) = 0;
    D(6,12) = 0;
    D(7,1) = -135555328849/8509847458140/(dx^2);
    D(7,2) = 11904122576/101307707835/(dx^2);
    D(7,3) = -5124426509/13507694378/(dx^2);
    D(7,4) = 43556319241/60784624701/(dx^2);
    D(7,5) = -80321706377/81046166268/(dx^2);
    D(7,6) = 73790130002/33769235945/(dx^2);
    D(7,7) = -950494905688/303923123505/(dx^2);
    D(7,8) = 239073018673/141830790969/(dx^2);
    D(7,9) = -145152/670091/(dx^2);
    D(7,10) = 18432/670091/(dx^2);
    D(7,11) = -1296/670091/(dx^2);
    D(7,12) = 0;
    D(8,1) = 0;
    D(8,2) = -2598164715/206729925524/(dx^2);
    D(8,3) = 10496900965/155047444143/(dx^2);
    D(8,4) = -44430275135/310094888286/(dx^2);
    D(8,5) = 425162482/2720130599/(dx^2);
    D(8,6) = -137529995233/620189776572/(dx^2);
    D(8,7) = 239073018673/155047444143/(dx^2);
    D(8,8) = -144648000000/51682481381/(dx^2);
    D(8,9) = 8128512/5127739/(dx^2);
    D(8,10) = -1016064/5127739/(dx^2);
    D(8,11) = 129024/5127739/(dx^2);
    D(8,12) = -9072/5127739/(dx^2);
    
    D(n,n) = D(1,1);
    D(n,n-1) = D(1,2);
    D(n,n-2) = D(1,3);
    D(n,n-3) = D(1,4);
    D(n,n-4) = D(1,5);
    D(n,n-5) = D(1,6);
    D(n,n-6) = D(1,7);
    D(n,n-7) = D(1,8);
    D(n,n-8) = D(1,9);
    D(n,n-9) = D(1,10);
    D(n,n-10) = D(1,11);
    D(n,n-11) = D(1,12);
    D(n-1,n) = D(2,1);
    D(n-1,n-1) = D(2,2);
    D(n-1,n-2) = D(2,3);
    D(n-1,n-3) = D(2,4);
    D(n-1,n-4) = D(2,5);
    D(n-1,n-5) = D(2,6);
    D(n-1,n-6) = D(2,7);
    D(n-1,n-7) = D(2,8);
    D(n-1,n-8) = D(2,9);
    D(n-1,n-9) = D(2,10);
    D(n-1,n-10) = D(2,11);
    D(n-1,n-11) = D(2,12);
    D(n-2,n) = D(3,1);
    D(n-2,n-1) = D(3,2);
    D(n-2,n-2) = D(3,3);
    D(n-2,n-3) = D(3,4);
    D(n-2,n-4) = D(3,5);
    D(n-2,n-5) = D(3,6);
    D(n-2,n-6) = D(3,7);
    D(n-2,n-7) = D(3,8);
    D(n-2,n-8) = D(3,9);
    D(n-2,n-9) = D(3,10);
    D(n-2,n-10) = D(3,11);
    D(n-2,n-11) = D(3,12);
    D(n-3,n) = D(4,1);
    D(n-3,n-1) = D(4,2);
    D(n-3,n-2) = D(4,3);
    D(n-3,n-3) = D(4,4);
    D(n-3,n-4) = D(4,5);
    D(n-3,n-5) = D(4,6);
    D(n-3,n-6) = D(4,7);
    D(n-3,n-7) = D(4,8);
    D(n-3,n-8) = D(4,9);
    D(n-3,n-9) = D(4,10);
    D(n-3,n-10) = D(4,11);
    D(n-3,n-11) = D(4,12);
    D(n-4,n) = D(5,1);
    D(n-4,n-1) = D(5,2);
    D(n-4,n-2) = D(5,3);
    D(n-4,n-3) = D(5,4);
    D(n-4,n-4) = D(5,5);
    D(n-4,n-5) = D(5,6);
    D(n-4,n-6) = D(5,7);
    D(n-4,n-7) = D(5,8);
    D(n-4,n-8) = D(5,9);
    D(n-4,n-9) = D(5,10);
    D(n-4,n-10) = D(5,11);
    D(n-4,n-11) = D(5,12);
    D(n-5,n) = D(6,1);
    D(n-5,n-1) = D(6,2);
    D(n-5,n-2) = D(6,3);
    D(n-5,n-3) = D(6,4);
    D(n-5,n-4) = D(6,5);
    D(n-5,n-5) = D(6,6);
    D(n-5,n-6) = D(6,7);
    D(n-5,n-7) = D(6,8);
    D(n-5,n-8) = D(6,9);
    D(n-5,n-9) = D(6,10);
    D(n-5,n-10) = D(6,11);
    D(n-5,n-11) = D(6,12);
    D(n-6,n) = D(7,1);
    D(n-6,n-1) = D(7,2);
    D(n-6,n-2) = D(7,3);
    D(n-6,n-3) = D(7,4);
    D(n-6,n-4) = D(7,5);
    D(n-6,n-5) = D(7,6);
    D(n-6,n-6) = D(7,7);
    D(n-6,n-7) = D(7,8);
    D(n-6,n-8) = D(7,9);
    D(n-6,n-9) = D(7,10);
    D(n-6,n-10) = D(7,11);
    D(n-6,n-11) = D(7,12);
    D(n-7,n) = D(8,1);
    D(n-7,n-1) = D(8,2);
    D(n-7,n-2) = D(8,3);
    D(n-7,n-3) = D(8,4);
    D(n-7,n-4) = D(8,5);
    D(n-7,n-5) = D(8,6);
    D(n-7,n-6) = D(8,7);
    D(n-7,n-7) = D(8,8);
    D(n-7,n-8) = D(8,9);
    D(n-7,n-9) = D(8,10);
    D(n-7,n-10) = D(8,11);
    D(n-7,n-11) = D(8,12);
    
    
    H = dx*spdiags([e],0,n,n);
    
    H(1,1) = dx*1498139/5080320;
    H(2,2) = dx*1107307/725760;
    H(3,3) = dx*20761/80640;
    H(4,4) = dx*1304999/725760;
    H(5,5) = dx*299527/725760;
    H(6,6) = dx*103097/80640;
    H(7,7) = dx*670091/725760;
    H(8,8) = dx*5127739/5080320;
    H(n,n) = H(1,1);
    H(n-1,n-1) = H(2,2);
    H(n-2,n-2) = H(3,3);
    H(n-3,n-3) = H(4,4);
    H(n-4,n-4) = H(5,5);
    H(n-5,n-5) = H(6,6);
    H(n-6,n-6) = H(7,7);
    H(n-7,n-7) = H(8,8);
    
    BS = (1/dx)*spdiags([zeros(size(e))],0,n,n);
    
    BS(1,1) = 4723/2100/dx;
    BS(1,2) = -839/175/dx;
    BS(1,3) = 157/35/dx;
    BS(1,4) = -278/105/dx;
    BS(1,5) = 103/140/dx;
    BS(1,6) = 1/175/dx;
    BS(1,7) = -6/175/dx;
    BS(n,n) = BS(1,1);
    BS(n,n-1) = BS(1,2);
    BS(n,n-2) = BS(1,3);
    BS(n,n-3) = BS(1,4);
    BS(n,n-4) = BS(1,5);
    BS(n,n-5) = BS(1,6);
    BS(n,n-6) = BS(1,7);
    
    
    S = (1/dx)*spdiags([e],0,n,n);
    
    S(1,1) = -4723/2100/dx;
    S(1,2) = 839/175/dx;
    S(1,3) = -157/35/dx;
    S(1,4) = 278/105/dx;
    S(1,5) = -103/140/dx;
    S(1,6) = -1/175/dx;
    S(1,7) = 6/175/dx;
    S(n,n) = BS(1,1);
    S(n,n-1) = BS(1,2);
    S(n,n-2) = BS(1,3);
    S(n,n-3) = BS(1,4);
    S(n,n-4) = BS(1,5);
    S(n,n-5) = BS(1,6);
    S(n,n-6) = BS(1,7);
    
else
    disp('Only order 2, 4, 6 or 8 implemented here.')
end