
function [g_left g_right] = boundary_cond_p_inf(mean_left,mean_right,sig_h,t,x0,left,right,p,m)

% Calculate time dependent boundary conditions for the first p coefficients of the infinite order expansion

% Indata:
% mean_left,mean_right - Left and right states
% sig_h - Standard deviation (uniform in space)
% t - Time
% x0 - Initial shock location
% left - Lower limit of spatial interval
% right - Upper limit of spatial interval
% p - Number of gPC coefficients to be computed
% m - Number of spatial grid points

% Outdata:
% g_left - Left boundary Dirichlet data for the vector of gPC coefficients
% g_right - Right boundary Dirichlet data for the vector of gPC coefficients


g_left = zeros(p*m,1);
g_right = zeros(p*m,1);

xi_l = (left-x0)./(sig_h*t)-(mean_left+mean_right)/(2*sig_h);
xi_r = (right-x0)./(sig_h*t)-(mean_left+mean_right)/(2*sig_h);
g_left(1) = mean_left + (mean_right-mean_left)*normcdf(xi_l,0,1);
g_right((m-1)*p+1) = mean_left + (mean_right-mean_left)*normcdf(xi_r,0,1);

g_left(2) = sig_h + (mean_left-mean_right)*exp(-xi_l^2/2)/sqrt(2*pi);
g_right((m-1)*p+2) = sig_h + (mean_left-mean_right)*exp(-xi_r^2/2)/sqrt(2*pi);
Psi_l(1:2) = [1 xi_l];
Psi_r(1:2) = [1 xi_r];

for k=3:p
    Psi_l(k) = xi_l.*sqrt(factorial(k-2)/factorial(k-1))*Psi_l(k-1) - (k-2)*sqrt(factorial(k-3)/factorial(k-1)).*Psi_l(k-2);
    Psi_r(k) = xi_r.*sqrt(factorial(k-2)/factorial(k-1))*Psi_r(k-1) - (k-2)*sqrt(factorial(k-3)/factorial(k-1)).*Psi_r(k-2);
    
    g_left(k) = (mean_left-mean_right)/sqrt(k-1)*exp(-xi_l^2/2)/sqrt(2*pi).*Psi_l(k-1);
    g_right((m-1)*p+k) = (mean_left-mean_right)/sqrt(k-1)*exp(-xi_r^2/2)/sqrt(2*pi).*Psi_r(k-1);
end

