
function [diss_op] = dissipation_4th_der(m,p,P2_inv,H_inv,const,dx)

% Dissipation operator corresponding to fourth order derivative to a system of size m*p (space * PCE-coeff.)
% Global dissipation constant

% Indata:
% m - Number of spatial grid points
% p - Number of gPC coefficients
% P2_inv - Inverse of SBP norm matrix P2
% H_inv - Inverse of SG mass matrix (in our implementation it is always the identity matrix) 
% const - Dissipation constant
% dx - Spatial grid size

% Outdata:
% diss_op - Discrete dissipation matrix

dia=[1 -2 1];
D2=spdiags(ones(m,1)*dia,[-1:1],m,m);
D2(1,1:3)=dia;
D2(m,m-2:m)=dia;

B2 = const*eye(m);
B2(1,1) = 0;

diss_op=kron(-dx*P2_inv*D2'*B2*D2,H_inv);