function [g0 g1] = bdy_cond_Legendre(rho_0,c1,c2,v,t,t0,x,x0,m,P)

% Compute Dirichlet data for the left boundary and Neumann data for the
% right boundary, assuming Legendre polynomials representation

% Indata:
% rho_0 - Solution scaling parameter (assumed deterministic)
% c1,c2 - Scaling parameters of uniform viscosity
% v - Advective velocity
% t - Time
% t0 - Initial time
% x - Vector of spatial grid points
% x0 - Initial pulse location
% m - Number of spatial grid points
% P - Number of gPC coefficients to be computed

% Outdata:
% g0 - Dirichlet data, left boundary
% g1 - Neumann data, right boundary


u_init = zeros(m*P,1);

%Legendre polynomials

basis_fun = cell(1,P);
basis_fun{1} = @(xi) xi.^0;
basis_fun{2} = @(xi) sqrt(3)*xi;
for k=3:P
    basis_fun{k} = @(xi) (sqrt(2*k-3)/(k-1)*xi.*basis_fun{k-1}(xi)-(k-2)/((k-1)*sqrt(2*k-5))*basis_fun{k-2}(xi) )*sqrt(2*k-1);
end

mu_fun = @(xi) c1+c2*xi;

g0 = zeros(m*P,1);
g1 = zeros(m*P,1);

for k=1:P
    integ_0 = @(xi) 0.5*basis_fun{k}(xi).*rho_0./sqrt(4*pi*mu_fun(xi)*(t+t0)).*exp(-(x(1)-(x0+v*(t+t0))).^2./(4*mu_fun(xi)*(t+t0)));
    g0(k,1) = quad(integ_0,-1,1);
    integ_1 = @(xi) 0.5*basis_fun{k}(xi).*rho_0./sqrt(4*pi*mu_fun(xi)*(t+t0)).*exp(-(x(end)-(x0+v*(t+t0))).^2./(4*mu_fun(xi)*(t+t0))).*(-(x(end)-(x0+v*(t+t0)))./(2*mu_fun(xi)*(t+t0)));
    g1((m-1)*P+k,1) = quad(integ_1,-1,1);
end
 
 