
function [C] = legendre_chaos(n)

% Compute Legendre chaos parameters

% Indata:
% n - Order of gPC

% Outdata:
% C - Three term inner products C(i,j,k) = E[Phi_i Phi_j Phi_k]


C = zeros(n+1,n+1,n+1);
for i = 0:n
    for j = 0:n
        for k = 0:n
            s = (i+k+j) / 2;
            if rem(i+k+j,2) == 1 || abs(i-j) > k || k > i+j
                C(i+1,j+1,k+1) = 0;
            else
                C(i+1,j+1,k+1) = sqrt((2*i+1)*(2*j+1)*(2*k+1))/(i+j+k+1)*A_for_lege(s-i)*A_for_lege(s-j)*A_for_lege(s-k)/A_for_lege(s);
            end
        end
    end
end
return