
function [g0] = bdy_cond_Dirichlet(rho_0,c1,c2,v,t,t0,x,x0,m,P)

% Generate left boundary data for Legendre polynomials and uniform viscosity

% Indata:
% rho_0 - Solution scaling parameter (assumed deterministic)
% c1,c2 - Scaling parameters of uniform viscosity
% v - Advective velocity
% t - Time
% t0 - Initial time
% x - Vector of spatial grid points
% x0 - Initial pulse location
% m - Number of spatial grid points
% P - Number of gPC coefficients to be computed

% Outdata:
% g0 - Dirichlet data, left boundary



u_init = zeros(m*P,1);

%Generate normalized Legendre polynomials recursively

basis_fun = cell(1,P);
basis_fun{1} = @(xi) xi.^0;
basis_fun{2} = @(xi) sqrt(3)*xi;
for k=3:P
    basis_fun{k} = @(xi) (sqrt(2*k-3)/(k-1)*xi.*basis_fun{k-1}(xi)-(k-2)/((k-1)*sqrt(2*k-5))*basis_fun{k-2}(xi) )*sqrt(2*k-1);
end

mu_fun = @(xi) c1+c2*xi;

g0 = zeros(m*P,1);

for k=1:P
    integ = @(xi) 0.5.*basis_fun{k}(xi).*rho_0.*(1-erf((x(1)-(x0+v*(t+t0)))./sqrt(4*mu_fun(xi)*(t+t0))));
    g0(k,1) = quad(integ,-1,1);
end