
function [g0 g1] = bdy_cond_Hermite(rho_0,c1,c2,v,t,t0,x,x0,m,P)

% Generate boundary data for Hermite polynomials and shifted lognormal viscosity

% Indata:
% rho_0 - Solution scaling parameter (assumed deterministic)
% c1,c2 - Scaling parameters of shifted lognormal viscosity
% v - Advective velocity
% t - Time
% t0 - Initial time
% x - Vector of spatial grid points
% x0 - Initial pulse location
% m - Number of spatial grid points
% P - Number of gPC coefficients to be computed

% Outdata:
% g0 - Dirichlet data, left boundary
% g1 - Neumann data, right boundary


tol = 15; % Replace infinite integration limit by sufficiently large real number

g0 = zeros(m*P,1);
g1 = zeros(m*P,1);
 
% Recursively generate Hermite polynomials
basis_fun = cell(1,P);
basis_fun{1} = @(xi) xi.^0;
basis_fun{2} = @(xi) xi;
for k=3:P
    basis_fun{k} = @(xi) 1/sqrt(k-1)*xi.*basis_fun{k-1}(xi)-sqrt((k-2)/(k-1))*basis_fun{k-2}(xi);
end

mu_fun = @(xi) c1+c2*exp(xi);

% Compute the gPC coefficients with numerical integration
for k=1:P
    integ = @(xi) 1/sqrt(2*pi).*exp(-xi.^2/2).*basis_fun{k}(xi).*rho_0./sqrt(4*pi*mu_fun(xi)*(t+t0)).*exp(-(x(1)-(x0+v*(t+t0))).^2./(4*mu_fun(xi).*(t+t0)));
    g0(k,1) = quad(integ,-tol,tol);
    
    integ = @(xi) -((x(end)-(x0+v*(t+t0)))./(2*mu_fun(xi)*(t+t0))).*(1/sqrt(2*pi).*exp(-xi.^2/2).*basis_fun{k}(xi).*rho_0./sqrt(4*pi*mu_fun(xi)*(t+t0)).*exp(-(x(end)-(x0+v*(t+t0))).^2./(4*mu_fun(xi).*(t+t0))));
    g1((m-1)*P+k,1) = quad(integ,-tol,tol);
end