
function [C] = Hermite_chaos(n)

% Compute hermite chaos parameters

% Indata:
% n - Order of gPC

% Outdata:
% C - Three term inner products C(i,j,k) = E[Phi_i Phi_j Phi_k]      


C = zeros(n+1,n+1,n+1);
for i = 0:n
    for j = 0:n
        for k = 0:n
            s = (i+k+j) / 2;
            if rem(i+k+j,2) == 1 || i > s || j > s || k > s
                C(i+1,j+1,k+1) = 0;
            else
                C(i+1,j+1,k+1) = factorial(i) * factorial(j) ...
                    *factorial(k) / ((factorial(s-i) * factorial(s-j) * factorial(s-k)) * sqrt(factorial(i)) * sqrt(factorial(j)) * sqrt(factorial(k)));
            end
        end
    end
end
return