
function [g_left g_right] = boundary_cond_determ(mean_left,mean_right,t,x0,left,right,m)

% Compute boundary conditions for the deterministic Burgers' equation

% Indata:
% mean_left,mean_right - Left and right states
% t - Time
% x0 - Initial shock location
% left - Lower limit of spatial interval
% right - Upper limit of spatial interval
% m - Number of spatial grid points

% Outdata:
% g_left - Left boundary Dirichlet data
% g_right - Right boundary Dirichlet data


g_left = zeros(m,1);
g_right = zeros(m,1);

% Shock speed
s = (mean_left + mean_right)/2;

if x0+s*t < left
   g_left(1) = mean_right; 
   g_right(end) = mean_right;
end

if x0+s*t >= left && x0+s*t <= right
   g_left(1) = mean_left;
   g_right(end) = mean_right;
end
    
if x0+s*t > right
   g_left(1) = mean_left;
   g_right(end) = mean_left; 
end