
function [diss_op] = dissipation_2nd_der(m,p,P_inv,H_inv,const,dx)

% Dissipation operator corresponding to second derivative to a system of size m*p (space * PCE-coeff.)
% Global dissipation constant

% Indata:
% m - Number of spatial grid points
% p - Number of gPC coefficients
% P_inv - Inverse of SBP norm matrix P
% H_inv - Inverse of SG mass matrix (in our implementation it is always the identity matrix) 
% const - Dissipation constant
% dx - Spatial grid size

% Outdata:
% diss_op - Discrete dissipation matrix

D = zeros(m)+diag(ones(m,1))-diag(ones(m-1,1),-1);
D(1,1) = -1;
D(1,2) = 1;
D = sparse(D);

B = const*eye(m*p);
B(1,1) = 0;
diss_op=-dx*kron(P_inv*D',eye(p))*B*kron(D,H_inv);

