
function [u_ref] = exact_solution_p_inf(mean_left,mean_right,sig_h,T,m,left,right,x0,x,p)

% Compute the analytical solution of the stochastic Burgers' equation with
% Hermite polynomials


% Indata:
% mean_left,mean_right - Mean (u_0) of the left and right states
% sig_h - Standard deviation (u_1), assumed uniform over the spatial domain
% T - Time
% m - Number of spatial grid points
% left - Lower limit of spatial interval
% right - Upper limit of spatial interval
% x0 - Initial shock location
% x - Vector of spatial grid points
% p - Number of gPC coefficients to be computed

% Outdata:
% u_ref - Analytical solution


y = zeros(m,1);
y(:,1)=(x-x0)./(sig_h*T)-(mean_left+mean_right)/(2*sig_h);

Psi_s = zeros(m,p);
Psi_s(:,1) = 1;
Psi_s(:,2) = y;


u_ref = zeros(m,p);
u_ref(:,1) = mean_left - (mean_left-mean_right)*normcdf(y,0,1);

if p>2
    u_ref(:,2) = sig_h + (mean_left-mean_right)*exp(-y.^2/2)/sqrt(2*pi);
    for k=3:p
        Psi_s(:,k) = y.*sqrt(factorial(k-2)/factorial(k-1)).*Psi_s(:,k-1) - (k-2)*sqrt(factorial(k-3)/factorial(k-1)).*Psi_s(:,k-2);
        u_ref(:,k) = (mean_left-mean_right)/sqrt(k-1)*exp(-y.^2/2)/sqrt(2*pi).*Psi_s(:,k-1);
    end
end