
function [Sig_left,Sig_right]=penalty(p,u_bc_l,u_bc_r,C)

% Assign penalty matrix for conservative system

% Indata:
% p - Number of gPC coefficients (p=M-1)
% u_bc_l, u_bc_r - Left and right boundary values
% C - Matrices of inner triple products of gPC basis functions

% Outdata:
% Sig_left, Sig_right - Left and right penalty matrices (SAT)

if p>1
    A_l = (C(:,:,1)*u_bc_l(1)+C(:,:,2)*u_bc_l(2));
    A_r = (C(:,:,1)*u_bc_r(1)+C(:,:,2)*u_bc_r(2));
    %Decomposition of the system matrix according to the signs of the
    %eigenvalues
    [X_l,D_l] = eig(A_l);
    [X_r,D_r] = eig(A_r);
    for i=1:p
        if D_l(i,i)<0
            D_l(i,i) = 0;
        end
        if D_r(i,i)>0
            D_r(i,i) = 0;
        end
    end
    A_l = X_l*D_l*X_l';
    A_r = X_r*D_r*X_r';
    
    %Scaling with 0.5 for conservative systems
    Sig_left = -1/2*A_l;
    Sig_right = 1/2*A_r;
    
end
if p==1
    Sig_left = -1/2*u_bc_l(1);
    Sig_right = 1/2*u_bc_r(1);
end
