%Script for solving linear regression problems in MATLAB
%Copyright 2015 Yuri Shardt
%To be used in conjunction with Chapter 7 of the Springer book, Statistics
%for Chemical and Process Engineers: A Modern Approach.

%Entering the raw data
m2=[0 600 1268 2013 2852 3803 4889]';
m3=[0 0.039 0.0823 0.1307 0.182 0.2469 0.3175]';
kc=[0 1052 2326 3879 5792 8170 11161]';
pi=[0 1314 2267 3712 5496 8035 11513]';
kdiss=1.678;
%Creating the required data matrices for solving the problem.
y=pi-kc;
A=[m3.^2+kdiss*m2.*m3 m3.^3]; %Note the use of the dot operator

y=y([1, 3:length(y)]);
A=A([1, 3:size(A,1)],:);

%Solve the problem to obtain the parameter estimates and associated
%information
[param,CI,residual,sr,info]=regress(y,A);

%display the results
fprintf(['B_3: %f%f\n'],param(1),(CI(1,2)-CI(1,1))/2);
fprintf(['C_3: %f%f\n'],param(2),(CI(2,2)-CI(2,1))/2);

%display the statistics
fprintf(['R^2 = %f\n'],info(1));

%examine the residuals
normplot(residual);
figure;plot(y,residual,'ok');xlabel('Measured value');ylabel('Residual');
figure;plot(A(:,1),residual,'ok');xlabel('First Regressor');ylabel('Residual');
figure;plot(A(:,2),residual,'ok');xlabel('Second Regressor');ylabel('Residual');
figure;plot(A*param,residual,'ok');xlabel('Predicted value');ylabel('Residual');
figure;plot(residual,'ok');xlabel('Sample');ylabel('Residual');
