function z=experiment(nb,nc,nd,nf,nk)
%Function to obtain system identification models of the data assuming a
%Box-Jenkins model with parameter orders nb, nc, nd, and nf with a time
%delay of nk.
%Copyright 2015 Yuri Shardt


load SystemIdentificationData;
newy1=Lower_Left_Level;
qnew=size(newy1);

%Plot the raw data
subplot(2,2,1), plot(U1)
xlabel('time (s)')
ylabel('flow rate, u (cm/s)')
title('Signal 1')
subplot(2,2,2), plot(U2)
xlabel('time (s)')
ylabel('flow rate, u (cm/s)')
title('Signal 2')
subplot(2,2,3), plot(newy1)
xlabel('time (s)')
ylabel('height, h (m)')
title('Tank 1')

%Create the data to store the object
z1=iddata([newy1],[U1,U2],1);
z1=detrend(z1,0);

%Obtain the parameter estimates
z=processbj(z1,nb,nc,nd,nf,nk,qnew);

end

function modelBJ=processbj(z1,nb,nc,nd,nf,nk,q)
%Partition the data set
split=ceil(2*q(1)/3);

%Obtain the parameter estimates
modelBJ=bj(z1(1:split),'nb',nb,'nc',nc,'nd',nd,'nf',nf,'nk',nk);

%Display the results
present(modelBJ)

%Plot the required residual analysis figures
figure
compare(modelBJ,z1(split+1:end))

figure
resid(modelBJ,z1(split+1:end)) %Note that the programme will pause here in order to for the first graph to be examined before displaying the next one.
r=resid(modelBJ,z1(split+1:end));
figure
normplot(r.OutputData);
end