%COM_Color_runN
%compression of color images
%when using SPIHT codec, image is converted from RGB to YUV format then the
%Y plane is compressed at compression ratio  `comp_rat` while U and V planes are
%compressed at compression ratio   thus, actual  compression
%ratio for the whole image is `3/2*comp_rat`
%when using JPEG2000, the whole image is compressed at compression ratio  `3/2*comp_rat`
%--------------------------- Load Parameters ----------------------------------

%list_images
params = loadParametersCO_col_N();

imageFileName = params{1};


pol_dis_qint= str2double(params{3});

Par= str2double(params{4});
IND=[pol_dis_qint,Par] ;
Proc_type= params{2};
DeTr = str2double(params{5});

Part_num = str2double(params{6});

Cod_type= params{7};
 % wavelet packet's order;

comp_rat= str2double(params{8});%compression ratio for Y plane 
exten= str2double(params{9});
PD= str2double(params{10});
blo=imread(imageFileName);

figure(1)
cj(blo)
if Cod_type=='jp'
 imwrite(uint8(blo),'temp.jp2','CompressionRatio',3/2*comp_rat,'ReductionLevels',DeTr);
restrgb = (imread('temp.jp2')); 

else
bloyuv=yuv2rgbN(blo,1);%conversion RGB to YUV
bloyuv=double(bloyuv);

[ve,ho,de]=size(bloyuv);
restyuv=zeros(ve,ho,de);
if Proc_type=='cc'
    DeTr=log2(ve/Part_num);
end
bloch=bloyuv(:,:,1);
 rest_image  = compr_proc(bloch,Proc_type,IND,DeTr,Part_num,exten,PD,Cod_type,comp_rat);
restyuv(:,:,1)=rest_image;

for kk=2:3
   bloch=bloyuv(:,:,kk); 
rest_image  = compr_proc(bloch,Proc_type,IND,DeTr,Part_num,exten,PD,Cod_type,2*comp_rat);
restyuv(:,:,kk)=rest_image;
end
restrgb=yuv2rgbN(restyuv,2);%conversion  YUV to RGB


restrgb=uint8(restrgb);
end
figure(2)
PSNR=psnB(double(blo),double(restrgb));
cj(restrgb)
title(['PSNR= ' num2str(PSNR)])


% Copyright (c) 2013. Valery A. Zheludev 