%
function [bsp, fbsp, samp_bsp, char_f]=per_dbspN(period,span,order)
%Computation of the discrete B-spline `bsp`, its DFT `fbsp`, samples on the
%sparse grid `samp_bsp` and the characteristic sequence `char_f`
N=period;
m=span;
P=order;
nu=1:N-1;
si=sin(pi*nu/N);

sim=sin(2^m*pi*nu/N);

fbsp=(sim./2^m./(si+eps)).^P;
fbsp=[1 fbsp];
bsp=real(ifft(fbsp));
samp_bsp=bsp(1:2^m:end);
 char_f=real(fft(samp_bsp));
% Copyright (c) 2013. Valery A. Zheludev