function pctran=fram34_dec_N(x,DeTr,IND,exten)
%3 or 4 -channel frame decomposition of a signal or an array of row signals
%'x' 
%DeTr-- depth of decomposition
%exten -- extension for recursive filtering
% IND-- index of frame 

%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- pol_dis_qint
% pol_dis_qint==1--polynom. interp. spline; ==2--discr. interp. spline; 
% pol_dis_qint==3-- quasiinterp. spline; ==4 --pseudospline

%IND(3)-- spline order; 
%IND(4)=0--tight frame, otherwise (IND(4)=1 or IND(4)=2)-- semi-tight frame

%if pd==-1 -- swap synthesis and analysis band-pass filters
%pctran--cell array of the transform coefficients
%IND=[4,3,31,K], K=0,1,2, means four-channel FB derived from quasiinterp.
%quadratic spline with interpolating low-pass filter
%IND=[4,3,32,K], K=0,1,2, means four-channel FB derived from quasiinterp.
%quadratic spline with  non-interpolating low-pass filter
[~ ,lh]=size(x);


if nargin<5
    pd=1;
end 
no_channel=IND(1);

[~, hp]=size(x);
pctran=cell(DeTr,no_channel);
x1=x;

for kk=1:DeTr
    
    %N=lh/2;
if no_channel==3
  
   
    [x1, h, s]= fram_down3N(x1,IND,exten);
pctran{kk,3}=h;
pctran{kk,2}=s;
elseif no_channel==4
    
 
    [x1, y1, y2, y3]= fram_down4N(x1,IND,exten);

pctran{kk,2}=y1;
pctran{kk,3}=y2;
pctran{kk,4}=y3;
end
lh=lh/2;
end
pctran{kk,1}=x1;
% Copyright (c) 2014. Valery A. Zheludev