function x=fram34_rec2d_N(pctran,DeTr,IND,exten,pd)
%3 or 4 -channel frame reconstruction of a 2D array 'x'
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3N.m' and 'list_frame4N.m'

%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- pol_dis_qint
% pol_dis_qint=1--polynom. interp. spline; =2--discr. interp. spline; 
% pol_dis_qint=3-- quasiinterp. spline; ==4 --pseudospline

%IND(3)-- spline order; 
%IND(4)=0--tight frame, otherwise -- semi-tight frame

%if pd==-1 -- swap synthesis and analysis band-pass filters

%pctran--cell array of the transform coefficients


no_channel=IND(1);
if nargin<5
    pd=1;
end 
x=pctran{DeTr}{1,1};

for kk=DeTr:-1:1
    Lev=pctran{kk};
   if no_channel==3 
    l=x';h=Lev{2,1}';s=Lev{3,1}';
 L=fram_up3N(l, h, s,IND,exten,pd)';
  l=Lev{1,2}';;h=Lev{2,2}';s=Lev{3,2}';  
  H=fram_up3N(l, h, s,IND,exten,pd)';  
    l=Lev{1,3}';;h=Lev{2,3}';s=Lev{3,3}';  
  S=fram_up3N(l, h, s,IND,exten,pd)';  
 x= fram_up3N(L, H, S,IND,exten,pd);
 
 
   elseif no_channel==4
     l=x';h=Lev{2,1}';s2=Lev{3,1}';s3=Lev{4,1}';
 L=fram_up4N(l, h, s2, s3,IND,exten,pd)';
  l=Lev{1,2}';;h=Lev{2,2}';s2=Lev{3,2}';s3=Lev{4,2}';  
  H=fram_up4N(l, h,  s2, s3,IND,exten,pd)';    
    l=Lev{1,3}';;h=Lev{2,3}';s2=Lev{3,3}'; s3=Lev{4,3}'; 
  S2=fram_up4N(l, h,  s2, s3,IND,exten,pd)';    
    l=Lev{1,4}';;h=Lev{2,4}';s2=Lev{3,4}'; s3=Lev{4,4}'; 
  S3=fram_up4N(l, h,  s2, s3,IND,exten,pd)';
 x= fram_up4N(L, H, S2,S3,IND,exten,pd);
end
end

% Copyright (c) 2015. Valery A. Zheludev