function [y2,y3] =framband_downN(IND,xe,xo,exten)
%band-pass filtering of  row signals or  arrays  of row signals "xe" and
%"xo" in 4-channel filter banks
%   dr=-1 -- decomp., dr=1 -- reconstruction
% IND-- index of frame 

%IND(1)=4 number of channels in filter bank (3 or 4) 
%IND(2)-- pol_dis_qint
% pol_dis_qint==1--polynom. interp. spline; ==2--discr. interp. spline; 
% pol_dis_qint==3-- quasiinterp. spline; ==4 --pseudospline
%exten -- extension for recursive filtering
%IND(3)-- spline order; 
%IND(4)=0--tight frame, otherwise (IND(4)=1 or IND(4)=2)-- semi-tight frame

Par=IND(3);
TS=IND(4);
IDQ=IND(2);
sq=sqrt(2);
[~,~,B] =slfilt_paramN(IND(2:3));
if TS==0% 2 vm, tight frame
         [y2,y3]=TS0(xe,xo,IND);
        % B=[];
       elseif TS==1| TS==2%symmetric | antisymmetric factorization 
         [y2,y3]=TS1(xe,xo,IND);  
        
       end  
 
lb=length(B);
if lb>0
    Y=[y2;y3];
    Y= caus_acaus_filt(B,Y,exten);Y=Y*prod(B);
  [y2,y3]=havsvB(Y);  
end 
end
function   [y2,y3]=TS0(xe,xo,IND)

y2=A_p( xe,IND,1)+A_p( xo,IND,-1);
       y3=-A_p( xe,IND,1)+A_p( xo,IND,-1);

end
function   [y2,y3]=TS1(xe,xo,IND)

y2=T_p( xe,IND,-1,1);
       y3=T_p(xo,IND,-1,2);

end

% Copyright (c) 2014. Valery A. Zheludev
   