function [s] =framband_filt3N(IND,dr,o,exten)
%band-pass filtering of a row signal or an array  of row signals "o"
%in 3-channel filter banks
%   dr=-1 -- decomp., dr=1 -- reconstruction
% IND-- index of frame 

%IND(1)=3 number of channels in filter bank (3 or 4) 
%IND(2)-- pol_dis_qint
% pol_dis_qint==1--polynom. interp. spline; ==2--discr. interp. spline; 
% pol_dis_qint==3-- quasiinterp. spline; ==4 --pseudospline
%exten -- extension for recursive filtering
%IND(3)-- spline order; 
%IND(4)=0--tight frame, otherwise (IND(4)=1 or IND(4)=2)-- semi-tight frame


Par=IND(3);
TS=IND(4);
IDQ=IND(2);
sq=sqrt(2);
[~,~,A] =slfilt_paramN(IND(2:3));
if IDQ==1
   if Par==2%linear spline
       TS=0;% 1 vm, tight frame
       s=(o-lshuk(dr,o,3))/2;
       B=[];
      elseif Par==3%quadratic interp. spline
          TS=0;% 2 vm, tight frame
s=zet2(o)*sq;
B=A;
elseif Par==4%cubic interp. spline
    if TS==0% 2 vm, tight frame
     B=A;
     q=7-4*sqrt(3);
     s=(o-q*lshuk(dr,o,3))/8/sqrt(q);
     s=zet2(s)*sq;
    elseif TS==1%symmetric factorization, 2 vm 
        B=A ;
        s=zet2(o)/2*sq; 
        if dr==1
         s=s/16;
         s=14*s-lshuk(1,s,3)-rshuk(1,s,3);
        end
        elseif TS==2%antisymmetric factorization, 2 vm, analysis filter FIR
         B=A;
         o=o*sq;
         
        if dr==-1
         s=(rshuk(2,o,3)-3*rshuk(1,o,3)+3*o-lshuk(1,o,3))/4;  
           
        elseif dr==1
            %s=(lshuk(1,o,3)-rshuk(1,o,3))*sq;
            s=-(lshuk(1,o,3)-o);
         s=(14*s-lshuk(1,s,3)-rshuk(1,s,3))/16;
        end
    end
   end
elseif IDQ==3%quasi-interpolating splines
       B=[];
       if Par==3%quadratic quasi-interpolating spline
       if TS==0% 2 vm, tight frame
         q=7-4*sqrt(3);
     s=(o-q*lshuk(dr,o,3))/16/sqrt(q);
     s=zet2(s)*sq; 
       elseif TS==1%symmetric factorization, 2 vm 
           s=zet2(o)*sq; 
        if dr==1
         s=s/64;
         s=14*s-lshuk(1,s,3)-rshuk(1,s,3);
        else
            s=s/4;
        end
        elseif TS==2%antisymmetric factorization, 2 vm, analysis filter FIR
         B=[];
         o=o*sq;
         
        if dr==-1
         s=(rshuk(2,o,3)-3*rshuk(1,o,3)+3*o-lshuk(1,o,3))/8;  
           
        elseif dr==1
            %s=(lshuk(1,o,3)-rshuk(1,o,3))*sq;
            s=-(lshuk(1,o,3)-o);
         s=(14*s-lshuk(1,s,3)-rshuk(1,s,3))/32;
        end
       end   
       end
       elseif IDQ==2%discrete splines (Butterworth filters)
           if Par==4%
               
s=zet2(o)*sq;
B=A;
elseif Par==6
B=A;
if TS==0%antisymmetric factorization, 3 vm,tight frame 
 o=o/sq/3;  
 s=rshuk(dr,o,3)-3*o+ 3*lshuk(dr,o,3)  -lshuk(2*dr,o,3);
 elseif TS==1%symmetric factorization, 2 vm in synth.wavelet,4 vm in analysis wavelet, 
     s=o/3; 
     if dr==1
     s=-zet2(s)*2; 
     elseif dr==-1
         s=(lshuk(2*dr,s,3)-4*lshuk(dr,s,3)+6*s +rshuk(2*dr,s,3)-4*rshuk(dr,s,3))/4;
     end
elseif TS==2%antisymmetric factorization, 1 vm in synth.wavelet,5 vm in analysis wavelet  
 s=o/3; 
     if dr==1
     s=-2*(lshuk(1,s,3)-s); 
     elseif dr==-1
         s=(lshuk(2,s,3)-5*lshuk(1,s,3)+10*s -10*rshuk(1,s,3)+5*rshuk(2,s,3)-rshuk(3,s,3))/4;
     end   
end
elseif Par==8
B=A;
if TS==0%symmetric factorization, 4 vm,tight frame 
  s=o*sq;  
  dr=1;
  s=(lshuk(2*dr,s,3)-4*lshuk(dr,s,3)+6*s +rshuk(2*dr,s,3)-4*rshuk(dr,s,3));
end
           end

end


lb=length(B);
if lb>0
    s= caus_acaus_filt(B,s,exten);s=s*prod(B);
end 
end
    %%%%%%%%%%%%%%%%%%%%
function y=zet2(x)
y=rshuk(1,x,3)+lshuk(1,x,3)-2*x;
end
% Copyright (c) 2014. Valery A. Zheludev
   