function grid = grid_des(x0,xN,N,p)
%design of (non-)uniform grid with N nodes for cubic spline approximation
%on the interval [x0,xN] with size of steps of power "p" growth

a=(0:N-1).^p;
sa=sum(a);
lx=xN-x0;
step_unit=lx/sa;
grid=zeros(1,N);
grid(1)=x0;
for kk=2:N
  grid(kk) = grid(kk-1)+a(kk)* step_unit; 
end

