function [ s0 ] = lsp0_u(t,f, g )

%value "s0" at the point "t" of the  simplest cubic spline  designed on a uniform  grid
%"g=(g(1),...,g(N))", which approximates the data "f=(f(1),...,f(N))"
%   the point "t" should be located inside the interval [t(3),t(N-3)]

[tk,k]=max(g(g<=t));

    K=(k-2):(k+3);
    X=g(K);
    Y=f(K);
hk=X(2)-X(1);
x=(t-tk)/hk;
F0=f(k)-2*f(k+1)+f(k+2);
G0=f(k-1)-2*f(k)+f(k+1);
s0=f(k)*(1-x)+f(k+1)*x+(G0*(1-x)^3+F0*x^3)/6;
end
% Copyright (c) 2015. Valery A. Zheludev