%GensplConsNF_examp
%Comparison of interpolating (fundamental) and global smoothing generators of spline spaces and their Fourier spectra

    lole=8;
    N=2^lole;

Ll=2;
    M=N*3^Ll;


    Par=[2 4 8 12];

Rho=.1*ones(1,4)

SP=[];SPi=[];
for kk=1:4
    P=Par(kk);
    rho=Rho(kk);
[spli]=spligenN3(6,P,N,Ll,rho);
SP=[SP;spli];
[mas,m]=max(spli);
lo=M/2-m;
spli=circ_h(spli,lo);

[ispli]=spligenN3(1,P,N,Ll,rho);
ispli=circ_h(ispli,lo);
SPi=[SPi;ispli];

end
x=(1:M)-M/2;y=x/3^Ll;

figure;
for kk=1:4
eval(['subplot(4,2,' int2str(2*kk-1) ')'])

a=[SP(kk,:) ];
set(gca,'FontSize',20)
plot(y,a,'k','LineWidth',3);
hold on
a=[SPi(kk,:) ];
plot(y,a,'--k','LineWidth',3);

% 
ma=min(a);Ma=max(a);
axis([-12 12 ma-.1 Ma+.1])

end
%figure;
for kk=1:4
     p=Par(kk);
    rho=Rho(kk);
    
eval(['subplot(4,2,' int2str(2*kk) ')'])
set(gca,'FontSize',20)
[a,b]=fplot(@(z)gen_specN(6,p, z,rho ),[-4*pi, 4*pi]);
plot(a,b,'k','LineWidth',3)
 hold on 
[a,b]= fplot(@(z)gen_specN(1,p, z,rho ),[-4*pi, 4*pi],'--');
plot(a,b,'--k','LineWidth',3)
 [hx,hy] = format_ticks(gca,{'$-4\pi$','$-3\pi$','$-2\pi$','$-\pi$','$0$','$\pi$','$2\pi$','$3\pi$','$4\pi$'},[],[-4*pi,-3*pi,-2*pi,-pi,0,pi,2*pi,3*pi,4*pi],[]);
hold off
   axis([-4*pi, 4*pi 0 1.1])
 end
