% spec_gen_plotN
%display Fourier spectra of generators of spline-wavelet spaces

tyge=[
    '1--B-wavelet;        '
    '2--Bwv-dual;         '
    '3--Battle;           '
               ];

disp(tyge)


type_gen=input('type of generator; ?')
eval(['load NOR' int2str(type_gen)])

P=[2 4  6 8];

figure;
for kk=1:4
eval(['subplot(2,2,' int2str(kk) ')'])

   p=P(kk);
   if type_gen==3
       nor=1;
   else
nor=NOR(kk);
   end
set(gca,'FontSize',20)
[a,b]=fplot(@(x)gen_Wv_specN(type_gen,p, x)/nor,[-4*pi, 4*pi]);
plot(a,b,'LineWidth',3);
 axis([-4*pi, 4*pi -0 1.2])
    
[hx,hy] = format_ticks(gca,{'$-4\pi$','$-3\pi$','$-2\pi$','$-\pi$','$0$','$\pi$','$2\pi$','$3\pi$','$4\pi$'},[],[-4*pi,-3*pi,-2*pi,-pi,0,pi,2*pi,3*pi,4*pi],[]);


set(gca,'YTickLabel',{})


title(['\fontsize{20}Spline order: '  int2str(Par(kk))])
set(gca,'FontSize',20)

end
