%gen_LSpl_consN3
%display  of local spline generators of spline spaces and their Fourier spectra 
%versus interpolating (fundamental) generators using ternary subdivision
%     'IND=[Par,0]--simplest spline order Par;        '
%     'IND=[3,1] --quadratic QIS                      '
%     'IND=[3,2] --quadratic EQIS                     '
%     'IND=[4,1] --cubic QIS                          '
%     'IND=[4,2] --cubic EQIS                         '
%     'IND=[5,1] --fifth-order intermediate generator ' 
%     'IND=[5,2] --fifth-order QIS                    '
%     'IND=[6,1] --sixth-order intermediate generator ' 
%     'IND=[6,2] --sixth-order QIS                    '
%     ];

Par=input('spline order; ?')

lole1=input('loglength of signal;0--former; ?')
if lole1>0
    lole=lole1;
    N=2^lole;
end

SdSt1=input('number of subdiv. iterations;0--former; ?')
if SdSt1>0
    SdSt=SdSt1;
    M=N*3^SdSt;
end


SP=[];
xx=zeros(1,N);xx(N/2)=1;
for Q=0:2
  IND=[Par,Q];
  [spli]=locspla_dif_curvN(xx,1:N,IND,SdSt,0,0);

[mas,m]=max(spli);
lo=M/2-m;
spli=circ_h(spli,lo);
SP=[SP;spli];

end
[spli]=spligenN3(1,Par,N,SdSt); 
[mas,m]=max(spli);
lo=M/2-m;
spli=circ_h(spli,lo);
SP=[SP;spli];


x=(1:M)-M/2;y=x/3^SdSt;

figure;
subplot(1,2,1)
for kk=1:4

a=[SP(kk,:) ];
plot(y,a,'LineWidth',3);
hold on

end
axis([-6 6 -.2 1.05])

title(['\fontsize{20}Spline order: '  int2str(Par)])
set(gca,'FontSize',16)
hold off
subplot(1,2,2)
for Q=0:2
  IND=[Par,Q];
    rho=0;%Rho(kk);
    
set(gca,'FontSize',20)
[a,b]=fplot(@(z)gen_LSpl_specN( IND, z ) ,[0, 3*pi],'--');
plot(a,b,'linewidth',3)
 hold on 
 
 end

 [a,b]=fplot(@(z)gen_specN(1,Par, z ),[0, 3*pi]);
 plot(a,b,'linewidth',3)
 axis([0, 3*pi -.1 1.1])


 hold off
   
