
function [spli]=intersplliNt(x,Par,SdSt,Type)
%binary/ternary  N-periodic spline subdivision
%x --values of the order-'Par' spline at integer points {n=0:N-1}, N=2^j
%SdSt -- number of subdivision steps
%Par-- order of spline (for binary subdivision should be even number)
%if  Type=2:calculation of the spline values 'spli'at dyadic rational points {n/2^SdSt}
%if  Type=3:calculation of the spline values 'spli'at triadic rational points {n/3^SdSt}

[vx N]=size(x);

M=N*Type^SdSt;

fx=fft(x,[],2);
[un,~]=juviP(Par,N);
[um,~]=juviP(Par,M);
un=repmat(un,vx,1);

f1=fx./(un+eps);

for kk=1:SdSt
    %f1=[f1 f1];
f1=repmat(f1,1,Type);
n=0:Type*N-1;
co=cos((Type-1)*pi*n/Type/N);
if Type==2
co=2*(co.^Par);
 
elseif Type==3
 co=3*(((1+2*co)/3).^Par); 
end
co=repmat(co,vx,1);
 f1=f1.*co;
 N=Type*N;
 
 
end
clear co
um=repmat(um,vx,1);
f1=f1.*um;
clear um
 spli = real(ifft(f1,[],2));




% % Copyright (c) 2012. Valery A. Zheludev
% 



