function FR= BW_specN(w,IND,type )
%Frequency responses of  spline-based filters
%type=1--low-pass analysis filter,
%type=2--high-pass analysis filter,
%type=3--low-pass synthesis filter,
%type=4--high-pass synthesis filter
q=sqrt(2);
Phi=lo_filt(w,IND);
Psi=lo_filt(w+pi,IND);
 W=Phi*Psi;  
if type==3
  FR= Phi/q; 
elseif type==1
  FR= (Phi+W)/q;
  elseif type==4
  FR= exp(-i*w)*(Psi+W)/q;
  elseif type==2
  FR= exp(-i*w)*(Psi)/q;
end
end
    function Phi=lo_filt(w,IND)
    if IND(1)==2%Butterworth wavelets 
        P=IND(2);
        Phi=2*(cos(w/2))^P/((cos(w/2))^P+(sin(w/2))^P);
    end
if IND==[1,2] %linear interp. spline
    
 Phi=2*(cos(w/2))^2;  
elseif IND==[1,3] %quadratic interp. spline
 Phi=(cos(w/2))^4*4/(1+(cos(w))^2);   
elseif IND==[1,4] %cubic interp. spline
 Phi=(cos(w/2))^4*2/(2+cos(2*w))*(2+cos(w));   
elseif IND==[1,5] %4-th degree interp. spline
 Phi=(cos(w/2))^6*8/(5+18*(cos(w))^2+(cos(w))^4)*(5+cos(w));   
 elseif IND==[3,3] %quadratic quasi-interp. spline
 Phi=(cos(w/2))^4*2*(2-(cos(w)));   
elseif IND==[3,4] %cubic quasi-interp. spline
 Phi=(cos(w/2))^4/9*(40-25*cos(w)+4*cos(2*w)-1*cos(3*w));   

end
end

