function [u1,u2,A] =slfilt_paramN(IND)
%provides parameters for spline-based prediction filters 
if IND==[1,3]%quadratic pl. spline 
A=3-2*sqrt(2);
  u1=4;u2=1;
elseif IND==[2,4]%4-th order discr. spline
A=3-2*sqrt(2);
  u1=4;u2=1;
elseif IND==[1,2]%linear pl. spline
    u1=1;u2=2;
    A=[];
elseif IND==[1,4]%cubic pl. interp. spline
 u1=[22,1];u2=8; 
 A=2-sqrt(3);
elseif IND==[1,5]% pl. interp. spline of 5-th order
 u1=[10,1];u2=1/16; 
 a1=19+4*sqrt(19)-2*sqrt(166+38*sqrt(19));
 a2=19-4*sqrt(19)-2*sqrt(166-38*sqrt(19));
 A=[a1,a2];
elseif IND==[3,3]|IND==[3,32]%quadratic quasi-int.pl. spline
 u1=[10,-1];u2=16; 
 A=[];

elseif IND==[4,4]% pseudospline
    u1=[10,-1];u2=16; 
 A=[];
elseif IND==[3,4]%cubic quasi-int.pl. spline
 u1=[174,-14,-1];u2=288; 
A=[];
elseif IND==[2,6]%6-th order discr. spline 
u1=[14,1];u2=6; 
A=1/3;
elseif IND==[2,8]%8-th order discr. spline 
u1=[6,1];u2=1/8; 
a2=7+4*sqrt(2)-2*sqrt(20+14*sqrt(2));
 a1=7-4*sqrt(2)-2*sqrt(20-14*sqrt(2));
 A=[a1,a2];
elseif IND==[2,10]%10-th order discr. spline 
u1=[166,44, 1];u2=10; 
a1=5-2*sqrt(5);a2=a1/5; 
A=[a1,a2];
end

end
% Copyright (c) 2014. Valery A. Zheludev
