%
function [FT ]=D_gen_specN(w,span,order,type)
%design of the magnitude of DTFT discrete spline generators `FT`,  at the point 'w'
%sampling `samp_sp` on the sparse grid 
%type=0 --  B-sp
%type=1 -- dual to B-sp
%type=2 -- fundamental sp
%type=3 -- self-dual sp
%type=4 --  B-sp wavelet
%type=5 -- self-dual sp wavelet
m=span;
P=order;
a=2^m;

nu=sin(a*w/2);

cnu=cos(a*w/2);
de=a*sin(w/2);


F=(nu/(de+eps))^P;


if type==1
    U2=dspl_charfun2(a*w,2*order,m);
    FT=F/(U2+eps);
elseif type==2
    U=dspl_charfun2(a*w,order,m);
    FT=F/(U+eps);
elseif type==3
      U2=dspl_charfun2(a*w,2*order,m);
    FT=F/(sqrt(U2)+eps);
elseif type==4
      Uc=a*dspl_charfun2(a*w+pi,2*order,m);
    FT=F*Uc*nu^P;
elseif type==5
      Uc=dspl_charfun2((a*w+pi),2*order,m);
       U2=dspl_charfun2(a*w,2*order,m);
       %Um=(Uc*nu^(2*P)+U2*cnu^(2*P))/2;
         %           
         Um=dspl_charfun2(2*a*w,2*P,m+1);
        
    FT=F*(nu^P)*Uc/sqrt(1*Uc*U2*Um+eps);

elseif type==0
    FT=F;
end   
end
 % Copyright (c) 2014. Valery A. Zheludev