function [U]=dspl_charfun2(w,Par,m)
%U-- characteristic function  at the point 'w*2^m' of the space S_{[m]} ^Par of discrete splines of order
%'Par' whose span is '2^m' and the shift parameter is 'M'

    U=0;

    for kk=0:(2^m-1)
        nu=sin(w/2+pi*kk)+eps;
        de=2^m*sin((w/2+pi*kk)/2^m)+eps;
        U=U+(nu/de)^Par;
    end
U=U/2^m;
end