function y = A_p( x,IND,pm)
%FIR filtering of signal or array of row signals "x"  for tight
%frames generated by four-channel filter banks 
%IND(2)-- pol_dis_qint
% pol_dis_qint=1--polynom. interp. spline; =2--discr. interp. spline; 
% pol_dis_qint=3-- quasiinterp. spline; ==4 --pseudospline

%IND(3)-- spline order; 
sq=sqrt(2);
Par=IND(3);

IDQ=IND(2);

if IDQ==1%interp. splines
 if Par==2%linear spline
     y=(x-hshif(x,pm))/4;
   elseif Par==3%quadratic interp. spline
       y=zet2(x)/2;
       elseif Par==4%cubic interp. spline
           q=7-4*sqrt(3);
           xx=x;
           y=(xx-q*hshif(xx,pm))/16/sqrt(q);
        y=zet2(y);
        
  elseif Par==5%fourth-degree interp. spline   
      q=49-20*sqrt(6);
        xx=(hshif(x,pm)-3*x+3*hshif(x,-pm)-hshif(x,-2*pm));
        
        y=(xx-q*hshif(xx,pm))/sqrt(q)/2;
 end
 
             %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif IDQ==3%quasi-interpolating splines
      
       if Par==3%quadratic quasi-interpolating spline (interpolating low-pass filter)
      q=7-4*sqrt(3);
        xx=zet2(x);
        y=(xx-q*hshif(xx,pm))/16/sqrt(q)/2;
        
       elseif Par==32%quadratic quasi-interpolating spline (non-interpolating low-pass filter)
            q1=0.073953753020242364122024941764069;
q2=0.039128545627548780526469694812049;
xx=zet2(x)/128/sqrt(q1*q2);
yy=xx-q1*hshif(xx,pm);
y=yy+q2*hshif(yy,pm);
       end
       
             %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif IDQ==2%discrete splines
      
       if Par==4%fourth-order discrete spline
       y=zet2(x)/2;
        elseif Par==6%sixth-order discrete spline
            y=(-hshif(x,-pm)+3*x-3*hshif(x,pm)+hshif(x,2*pm))/4/3;
      elseif Par==8%eighth-order discrete spline
%            
y=-zet4(x)/2;
       end
       
             %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        elseif IDQ==4%pseudo-spline
 q1=0.084036721311635863751390197446785;
q2=0.066541718952892961207287011854059;
xx=zet2(x)/256/sqrt(q1*q2)*3;
yy=xx-q1*hshif(xx,pm);
y=yy+q2*hshif(yy,pm);    
end
end

 %%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
function y=zet2(x)
y=-hshif(x,1)-hshif(x,-1)+2*x;
end

function y=zet4(x)
y=hshif(x,2)-4*hshif(x,1)-4*hshif(x,-1)+6*x+hshif(x,-2);
end


