function FR= fram3_specN(w,IND,type )
%Frequency responses of  spline-based filters for 3-channel filter banks
%type=1--low-pass  filter,
%type=2--high-pass  filter,
%type=3--band-pass analysis filter,
%type=4--high-pass synthesis filter
sq=sqrt(2);
IND23=IND(2:3);
IND24=IND(2:4);
Phi=low_filt(w,IND23);
Psi=low_filt(w+pi,IND23);

if type==1
  FR= Phi/sq; 
elseif type==2
  FR= (Psi)/sq;
  elseif type==4
  FR= band_fil(w,IND24,type )/sq;
  elseif type==3
 FR= band_fil(w,IND24,type )/sq;
end
end

    function Phi=low_filt(w,IND23)
    if IND23(1)==2%Butterworth wavelets 
        P=IND23(2);
        Phi=2*(cos(w/2))^P/((cos(w/2))^P+(sin(w/2))^P);
    end
if IND23==[1,2] %linear interp. spline
    
 Phi=2*(cos(w/2))^2;  
elseif IND23==[1,3] %quadratic interp. spline
 Phi=(cos(w/2))^4*4/(1+(cos(w))^2);   
elseif IND23==[1,4] %cubic interp. spline
 Phi=(cos(w/2))^4*2/(2+cos(2*w))*(2+cos(w));   
elseif IND23==[1,5] %4-th degree interp. spline
 Phi=(cos(w/2))^6*8/(5+18*(cos(w))^2+(cos(w))^4)*(5+cos(w));   
 elseif IND23==[3,3] %quadratic quasi-interp. spline
 Phi=(cos(w/2))^4*2*(2-(cos(w)));   
elseif IND23==[3,4] %cubic quasi-interp. spline
 Phi=(cos(w/2))^4/9*(40-25*cos(w)+4*cos(2*w)-1*cos(3*w));   

end
    end
    function Bet=band_fil(w,IND24,type )
    sq=sqrt(2);
     if IND24==[1,2,0] %linear interp. spline tight frame
            Bet=sin(w);
      elseif IND24==[1,3,0] %quadratic interp. spline tight frame
 Bet=(sin(w))^2/((sin(w/2))^4+(cos(w/2))^4)/sq; 
 
    elseif IND24==[1,4,0] %cubic interp. spline tight frame
        q=7-4*sqrt(3);
        
 Bet=(sin(w))^2/sq/sqrt(q)/(ew(2*w)+4+ew(-2*w))*(1-q*ew(2*w)); 
  elseif IND24==[1,4,1] %cubic interp. spline semi-tight frame, symmetric fact.
      if type==3
      Bet=(sin(w))^2*sq/(ew(2*w)+4+ew(-2*w))*2;    
      elseif type==4
      Bet=(sin(w))^2*sq/4/(ew(2*w)+4+ew(-2*w))*(14-ew(2*w)-ew(-2*w))/2;    
      end
      elseif IND24==[1,4,2] %cubic interp. spline semi-tight frame, antisymmetric fact.
      if type==3
      Bet=3*(ew(4*w)-3*ew(2*w)+3-ew(-2*w))/sq/(ew(2*w)+4+ew(-2*w))/6;    
      elseif type==4
      Bet=(1-ew(2*w))*sq/48/(ew(2*w)+4+ew(-2*w))*(14-ew(2*w)-ew(-2*w))*3;    
      end
     elseif IND24==[2,4,0]%%fourth-order discrete  spline tight frame --2 vm.
       Bet=(sin(w))^2/((sin(w/2))^4+(cos(w/2))^4)/sq;   
     elseif IND24==[2,6,0]%%sixth-order discrete  spline tight frame --3 vm.
         Bet=ew(-2*w)*(1-ew(2*w))^3/sq/(3*ew(2*w)+10+3*ew(-2*w));
         elseif IND24==[2,6,1]%%sixth-order discrete  spline semi-tight frame, symmetric fact.
        if type==3     
         Bet=(ew(-w)-ew(w))^4*sq/(3*ew(2*w)+10+3*ew(-2*w))/4;
        elseif type==4     
         Bet=(ew(-w)-ew(w))^2*sq/(3*ew(2*w)+10+3*ew(-2*w));
        end 
         elseif IND24==[2,6,2]%%sixth-order discrete  spline semi-tight frame, antisymmetric fact.
        if type==4     
         Bet=ew(-4*w)*(ew(2*w)-1)*2*sq/(3*ew(2*w)+10+3*ew(-2*w));
        elseif type==3     
         Bet=ew(-2*w)*(ew(2*w)-1)^5*sq/(3*ew(2*w)+10+3*ew(-2*w))/8;
        end 
        elseif IND24==[2,8,0]%%eighth-order discrete  spline tight frame --4 vm.
         Bet=(ew(-w)-ew(w))^4*sq/(ew(4*w)+28*ew(2*w)+70+28*ew(-2*w)+ew(-4*w));   
          elseif IND24==[3,3,0] %quadratic quasi-interp. spline tight frame
        q=7-4*sqrt(3);
        
 Bet=(sin(w))^2*sq/sqrt(q)/4*(1-q*ew(2*w)); 
  elseif IND24==[3,3,1] %quadratic quasi-interp. semi-tight frame, symmetric fact.
      if type==3
      Bet=(sin(w))^2*sq;    
      elseif type==4
      Bet=(sin(w))^2*sq/16*(14-ew(2*w)-ew(-2*w));    
      end
      elseif IND24==[3,3,2] %quadratic quasi-interp. semi-tight frame, antisymmetric fact.
      if type==3
      Bet=(ew(4*w)-3*ew(2*w)+3-ew(-2*w))*sq/8;    
      elseif type==4
      Bet=(1-ew(2*w))*sq/32*(14-ew(2*w)-ew(-2*w));    
      end
     end   
     Bet=abs(Bet);
    end
    function ee=ew(w)
    ee=exp(i*w);
    end

% Copyright (c) 2014. Valery A. Zheludev