function x=fram34_rec_N(pctran,DeTr,IND,exten,pd)
%3 or 4 -channel frame reconstruction of a signal or an array of row signals 'x'
%pctran--cell array of the transform coefficients
%DeTr-- depth of decomposition
% IND-- index of frame from the lists given in the codes
% 'list_frame3.m' and 'list_frame4.m'
%IND(1)-- number of channels in filter bank (3 or 4) 
%IND(2)-- spline order; 
%IND(3)=0--tight frame, otherwise -- semi-tight frame
%if pd==-1 -- swap synthesis and analysis band-pass filters
%exten -- extension for recursive filtering

Par=IND(3);
TS=IND(4);

if nargin<5
    pd=1;
end 
x=pctran{DeTr,1};
[lv,N]=size(x);
no_channel=IND(1);
for kk=DeTr:-1:1
    if no_channel==3
h=pctran{kk,3};
s=pctran{kk,2};
x= fram_up3N(x, h, s,IND,exten,pd);
    elseif  no_channel==4
     y1=pctran{kk,2};
y2=pctran{kk,3};
y3=pctran{kk,4};
 
x=fram_up4N(x,y1,y2,y3,IND,exten,pd);
[lv,N]=size(x);
    end
end
% Copyright (c) 2014. Valery A. Zheludev