function FR= fram4_specN(w,IND,type )
%Frequency responses of  spline-based filters
%type=0--low-pass  filter h^0,
%type=1--high-pass  filter h^1,
%type=21--band-pass analysis filter \tilde{h}^2,
%type=22--band-pass synthesis filter h^2
%type=31--band-pass analysis filter \tilde{h}^3,
%type=32--band-pass synthesis filter h^3
sq=sqrt(2);
wp=exp(i*w);
wm=exp(-i*w);
IND23=IND(2:3);
IND24=IND(2:4);
Phi=low_filtN(w,IND23);
Psi=low_filtN(w+pi,IND23);
TS=IND(4);
if type==0
  FR= Phi*sq; 
elseif type==1
  FR= (Psi)*sq;
  elseif type==21
  if TS==0
FR=A_w( w*2,IND,-1)+wm*A_w( w*2,IND,1);
  elseif TS==1|TS==2
   FR=T_w(w*2,IND,1,1);   
  end
 elseif type==22
  if TS==0
FR=A_w( w*2,IND,-1)+wm*A_w( w*2,IND,1);
elseif TS==1|TS==2
   FR=T_w(w*2,IND,1,2);  
  end
elseif type==31
  if TS==0
FR=-A_w(w*2,IND,-1)+wm*A_w( w*2,IND,1);
elseif TS==1|TS==2
   FR=T_w(w*2,IND,1,2)*wm;
  end
elseif type==32
  if TS==0
FR=-A_w( w*2,IND,-1)+wm*A_w( w*2,IND,1);
elseif TS==1|TS==2
   FR=T_w(w*2,IND,1,1)*wm;
  end
end
FR=abs(FR);
end

    function Phi=low_filtN(w,IND23)
    wp=exp(i*w);
wm=exp(-i*w);
    if IND23(1)==2%Butterworth wavelets 
        P=IND23(2);
        Phi=2*(cos(w/2))^P/((cos(w/2))^P+(sin(w/2))^P);
    elseif IND23(1)==4%pseudo-spline
   Phi=(cos(w/2))^6*(1+3*(sin(w/2))^2);    
    end
if IND23==[1,2] %linear interp. spline
    
 Phi=2*(cos(w/2))^2;  
elseif IND23==[1,3] %quadratic interp. spline
 Phi=(cos(w/2))^4*4/(1+(cos(w))^2);   
elseif IND23==[1,4] %cubic interp. spline
 Phi=(cos(w/2))^4/(wp^2+4+wm^2)*(wp+4+wm)*2;   
%Phi=(cos(w/2))^4*2/(2+cos(2*w))*(2+cos(w));   
elseif IND23==[1,5] %4-th degree interp. spline
 Phi=(cos(w/2))^6*8/(5+18*(cos(w))^2+(cos(w))^4)*(5+cos(w));   
 elseif IND23==[3,3] %quadratic quasi-interp. spline (interp. low-pass filter)
 Phi=(cos(w/2))^4*2*(2-(cos(w)));   
elseif IND23==[3,32] %quadratic quasi-interp. spline (non-interp. low-pass filter)
 Phi=(cos(w/2))^4*(3-(cos(w)));   
elseif IND23==[3,4] %cubic quasi-interp. spline
 Phi=(cos(w/2))^4/9*(40-25*cos(w)+4*cos(2*w)-1*cos(3*w));   



end

    end
    

% Copyright (c) 2014. Valery A. Zheludev