function [y0,y1] =slfilt4_downN(xe ,xo,IND , exten)
%low-pass filtering of  row signals or  arrays  of row signals "xe" and
%"xo" in 4-channel filter banks using spline based prediction  filters
%   dr=-1 -- decomp., dr=1 -- reconstruction
% IND-- index of frame 

%IND(1)=4 number of channels in filter bank (3 or 4) 
%IND(2)-- pol_dis_qint
% pol_dis_qint==1--polynom. interp. spline; ==2--discr. interp. spline; 
% pol_dis_qint==3-- quasiinterp. spline; ==4 --pseudospline
%exten -- extension for recursive filtering
%IND(3)-- spline order; 
%IND(4)=0--tight frame, otherwise (IND(4)=1 or IND(4)=2)-- semi-tight frame
sq=sqrt(2);
[u1,u2,A,v1,v2] =slfilt_param4N(IND);

lv=length(v1);

xO=xo+hshif(xo,1);
xE=xe+hshif(xe,-1);
   
ye=filX(xE,A,exten,u1,u2);
yo=filX(xO,A,exten,u1,u2);
%[ye,yo]=havsvB(Y);
if lv==1
Xe=xe;
Xo=xo;
else
Z=[xe;xo]; 
zn=v1(1)*Z;
ff=0;
for kk=1:(lv-1)
    ff=ff+v1(kk+1)*(hshif(Z,kk)+hshif(Z,-kk));
end
Z=(zn+ff)/v2; 
[ze,zo]=havsvB(Z); 
 Xe=ze;
Xo=zo;
end
y0=(Xe+yo)/sq;
y1=(Xo-ye)/sq;
end

% Copyright (c) 2014. Valery A. Zheludev
